package net.wicp.tams.component.constant.list;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.ioc.Messages;

import net.wicp.tams.commons.apiext.JSONUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.component.tools.convert.ConvertValueEnum;

/***
 * 是与否枚举
 * 
 * @author Administrator
 * 
 */
public enum YesOrNo {
	yes("是"), no("否");

	private final String desc;

	private YesOrNo(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	public static YesOrNo find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (YesOrNo ele : YesOrNo.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

	public static String buildList(Messages messages) {
		List<YesOrNo> retlist = Arrays.asList(YesOrNo.values());
		if (messages == null) {
			return JSONUtil.getJsonForListAlias(retlist);
		}
		Map<String, IConvertValue> conMap = new HashMap<String, IConvertValue>();
		conMap.put("name1", new ConvertValueEnum(YesOrNo.class, messages));
		String retstr = JSONUtil.getJsonForListAlias(retlist,
				new String[] { "name,name1" }, conMap);
		return retstr;
	}
}
