package net.wicp.tams.component.constant.list;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.tapestry5.ioc.Messages;

import net.wicp.tams.commons.apiext.JSONUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import net.wicp.tams.component.tools.convert.ConvertValueEnum;

/***
 * 是与否枚举
 * 
 * @author Administrator
 * 
 */
public enum Gender {
	M("男"), F("女"), U("未知");
	private final String desc;

	private Gender(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	public static String buildList(Messages messages) {
		List<Gender> retlist = Arrays.asList(Gender.values());
		if (messages == null) {
			return JSONUtil.getJsonForListAlias(retlist);
		}
		Map<String, IConvertValue> conMap = new HashMap<String, IConvertValue>();
		conMap.put("name1", new ConvertValueEnum(Gender.class, messages));
		String retstr = JSONUtil.getJsonForListAlias(retlist,
				new String[] { "name,name1" }, conMap);
		return retstr;
	}
}
