/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.web.easyuibean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.commons.apiext.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;

public class EasyUINode
implements Comparable<EasyUINode> {
    private String id;
    private String text;
    private String iconCls;
    private boolean isClose;
    private Boolean checked;
    private EasyUINode parent;
    private int index = 99999;
    private Map<String, String> attributes;
    private List<EasyUINode> childrens;
    private final Map<String, EasyUINode> allSubMap = new HashMap<String, EasyUINode>();

    public EasyUINode(String id, String text) {
        this.id = id;
        this.text = text;
    }

    public EasyUINode(String id) {
        this.id = id;
    }

    public EasyUINode getSubById(String id) {
        return this.allSubMap.get(id);
    }

    public Map<String, EasyUINode> getSubs() {
        return this.allSubMap;
    }

    public void addRootMap(EasyUINode add) {
        this.allSubMap.put(add.getId(), add);
    }

    public JSONObject toJson() {
        Validate.notBlank((CharSequence)this.id);
        Validate.notBlank((CharSequence)this.text);
        JSONObject retobj = new JSONObject(new Object[]{"id", this.id, "text", this.text, "index", this.index});
        retobj.put("parentId", (Object)(this.parent == null ? "" : StringUtil.hasNull(this.parent.getIconCls(), "")));
        if (StringUtils.isNotBlank((CharSequence)this.iconCls)) {
            retobj.put("iconCls", (Object)this.iconCls);
        }
        if (this.checked != null) {
            retobj.put("checked", (Object)this.checked);
        }
        if (MapUtils.isNotEmpty(this.attributes)) {
            JSONObject attr = new JSONObject();
            for (String key : this.attributes.keySet()) {
                attr.put(key, (Object)this.attributes.get(key));
            }
            retobj.put("attributes", (Object)attr);
        }
        if (CollectionUtils.isNotEmpty(this.childrens)) {
            if (this.isClose) {
                retobj.put("state", (Object)"closed");
            } else {
                retobj.put("state", (Object)"open");
            }
            Collections.sort(this.childrens);
            JSONArray childAry = new JSONArray();
            for (EasyUINode easyUINode : this.childrens) {
                childAry.put((Object)easyUINode.toJson());
            }
            retobj.put("children", (Object)childAry);
        }
        return retobj;
    }

    @Override
    public int compareTo(EasyUINode o) {
        EasyUINode tempobj = o;
        return this.index - tempobj.index;
    }

    public void addChildres(EasyUINode addNode) {
        if (this.childrens == null) {
            this.childrens = new ArrayList<EasyUINode>();
        }
        ArrayList<EasyUINode> list = new ArrayList<EasyUINode>();
        list.add(addNode);
        this.putAllSubMap(list);
        this.childrens.add(addNode);
    }

    public void addChildres(List<EasyUINode> addNodes) {
        if (CollectionUtils.isNotEmpty(addNodes)) {
            if (this.childrens == null) {
                this.childrens = new ArrayList<EasyUINode>();
            }
            this.putAllSubMap(addNodes);
            this.childrens.addAll(addNodes);
        }
    }

    private void putAllSubMap(List<EasyUINode> addNodes) {
        if (CollectionUtils.isEmpty(addNodes)) {
            return;
        }
        for (EasyUINode subNode : addNodes) {
            subNode.setParent(this);
            EasyUINode.putAncestor(this, subNode);
        }
    }

    private static void putAncestor(EasyUINode parent, EasyUINode sub) {
        if (parent == null || sub == null) {
            return;
        }
        parent.addRootMap(sub);
        if (parent.getParent() != null) {
            EasyUINode.putAncestor(parent.getParent(), sub);
        }
    }

    public void addAttributes(String ... attr) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        if (ArrayUtils.isNotEmpty((Object[])attr)) {
            for (int i = 0; i < attr.length / 2; ++i) {
                this.attributes.put(attr[2 * i], attr[2 * i + 1]);
            }
        }
    }

    public String getAttribute(String attrName) {
        return this.attributes.get(attrName);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getIconCls() {
        return this.iconCls;
    }

    public void setIconCls(String iconCls) {
        this.iconCls = iconCls;
    }

    public Boolean getChecked() {
        return this.checked;
    }

    public void setChecked(Boolean checked) {
        this.checked = checked;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isClose() {
        return this.isClose;
    }

    public void setClose(boolean isClose) {
        this.isClose = isClose;
    }

    public EasyUINode getParent() {
        return this.parent;
    }

    public void setParent(EasyUINode parent) {
        this.parent = parent;
    }

    public List<EasyUINode> getChildrens() {
        return this.childrens;
    }
}

