/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.mybatis.service.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.wicp.tams.commons.LogHelp;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.mybatis.service.IbatisService;
import net.wicp.tams.commons.web.PageAssist;
import net.wicp.tams.commons.web.service.IPageBuild;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;
import org.apache.tapestry5.json.JSONObject;
import org.slf4j.Logger;

public class BatisServiceImpl
implements IbatisService {
    private final Logger logger = LogHelp.getLogger(this.getClass());
    private SqlSession sqlSession;
    private IPageBuild pageBuild;

    @Override
    public List<Map<String, Object>> queryForList(String sqlId, Object ... keysAndValues) {
        if (ArrayUtils.isEmpty((Object[])keysAndValues)) {
            return this.queryForList(sqlId, new HashMap());
        }
        JSONObject json = new JSONObject(keysAndValues);
        return this.queryForList(sqlId, json.toMap());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sqlId, Map params) {
        long t1 = System.currentTimeMillis();
        List list = this.sqlSession.selectList(sqlId, (Object)params);
        long t2 = System.currentTimeMillis();
        this.logger.info("\"{}\"\u67e5\u8be2\u8017\u65f6{}ms\uff1a", (Object)sqlId, (Object)(t2 - t1));
        return list;
    }

    @Override
    public PageAssist queryForPagedList(String listSqlId, String countSqlId, Map params, int pageSize, int pageNo, long countNum, boolean pagedByDb) {
        RowBounds rowbound = new RowBounds((pageNo - 1) * pageSize, pageSize);
        String countSqlIdTrue = StringUtil.hasNull(countSqlId, listSqlId + "_count");
        long t1 = System.currentTimeMillis();
        PageAssist pc = new PageAssist(pageSize, pageNo);
        if (countNum < 0L) {
            Object obj = this.sqlSession.selectOne(countSqlIdTrue, (Object)params);
            if (obj != null) {
                int allNum = (Integer)obj;
                pc.setAllNum(allNum);
            }
        } else {
            pc.setAllNum(countNum);
        }
        long t2 = System.currentTimeMillis();
        this.logger.info("{}\uff1a\u67e5\u8be2\u603b\u6570\u8017\u65f6{}ms\uff1a", (Object)listSqlId, (Object)(t2 - t1));
        if (pagedByDb) {
            List list = this.sqlSession.selectList(listSqlId, (Object)params, rowbound);
            pc.setResult(list);
            long t3 = System.currentTimeMillis();
            this.logger.info("{}\uff1a\u771f\u5206\u9875\u67e5\u8be2\u8017\u65f6{}ms\uff1a", (Object)listSqlId, (Object)(t3 - t2));
            return pc;
        }
        List list = this.sqlSession.selectList(listSqlId, (Object)params);
        pc.setResult(list);
        long t3 = System.currentTimeMillis();
        this.logger.info("{}\uff1a\u5047\u5206\u9875\u67e5\u8be2\u8017\u65f6{}ms\uff1a", (Object)listSqlId, (Object)(t3 - t2));
        return pc;
    }

    @Override
    public PageAssist queryForPagedList(String listSqlId, String countSqlId, Map params, HttpServletRequest request, boolean pagedByDb) {
        PageAssist pageAssist = this.pageBuild.build(request);
        return this.queryForPagedList(listSqlId, countSqlId, params, pageAssist.getPageSize(), pageAssist.getPageNo(), pageAssist.getAllNum(), pagedByDb);
    }

    @Override
    public PageAssist queryForPagedList(String listSqlId, Map params, HttpServletRequest request, boolean pagedByDb) {
        PageAssist pageAssist = this.pageBuild.build(request);
        return this.queryForPagedList(listSqlId, null, params, pageAssist.getPageSize(), pageAssist.getPageNo(), pageAssist.getAllNum(), pagedByDb);
    }

    @Override
    public PageAssist queryForPagedList(String listSqlId, Map params, HttpServletRequest request) {
        PageAssist pageAssist = this.pageBuild.build(request);
        return this.queryForPagedList(listSqlId, null, params, pageAssist.getPageSize(), pageAssist.getPageNo(), pageAssist.getAllNum(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List executeSqlQuery(String sql, Object[] inParams) {
        ArrayList list = new ArrayList();
        PreparedStatement proc = null;
        ResultSet rs = null;
        try {
            Connection conn = this.sqlSession.getConnection();
            proc = conn.prepareStatement(sql);
            for (int i = 0; inParams != null && i < inParams.length; ++i) {
                proc.setObject(i + 1, inParams[i]);
            }
            rs = proc.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int num = rsmd.getColumnCount();
            while (rs.next()) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int j = 0; j < num; ++j) {
                    row.add(rs.getObject(j + 1));
                }
                list.add(row);
            }
            ArrayList arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            this.logger.error("SQL\u8bed\u53e5\u6267\u884c\u9519\u8bef.", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.error("\u5173\u95edrs\u9519\u8bef");
                }
            }
            if (proc != null) {
                try {
                    proc.close();
                }
                catch (SQLException e) {
                    this.logger.error("\u5173\u95edPreparedStatement\u9519\u8bef");
                }
            }
        }
        return list;
    }

    @Override
    public int saveOrUpdateEntity(String sqlId, Object entity, boolean update) {
        if (update) {
            return this.sqlSession.update(sqlId, entity);
        }
        return this.sqlSession.insert(sqlId, entity);
    }

    @Override
    public int saveOrUpdateEntity(Object entity, boolean update) {
        String clsName = entity.getClass().getSimpleName();
        clsName = update ? clsName + "_update" : clsName + "_insert";
        return this.saveOrUpdateEntity(clsName, entity, update);
    }

    @Override
    public void deleteEntity(String sqlId, Object parameterObject) {
        this.sqlSession.delete(sqlId, parameterObject);
    }

    @Override
    public void deleteEntity(Object entity) {
        String clsName = entity.getClass().getSimpleName();
        this.deleteEntity(clsName + ".delete", entity);
    }

    @Override
    public int updateRecord(String sqlId, Map params) {
        return this.saveOrUpdateEntity(sqlId, params, true);
    }

    @Override
    public int insertRecord(String sqlId, Map params) {
        return this.saveOrUpdateEntity(sqlId, params, false);
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public void setSqlSession(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    public IPageBuild getPageBuild() {
        return this.pageBuild;
    }

    public void setPageBuild(IPageBuild pageBuild) {
        this.pageBuild = pageBuild;
    }
}

