/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.mq.rocketmq;

import com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.alibaba.rocketmq.client.producer.SendResult;
import com.alibaba.rocketmq.common.message.Message;
import java.net.InetAddress;
import java.util.Properties;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.LogHelp;
import org.slf4j.Logger;

public class SendMsgRocket {
    private static final Logger logger = LogHelp.getLogger(SendMsgRocket.class);
    private static volatile SendMsgRocket INSTANCE;
    private static Object lockobj;
    private DefaultMQProducer producer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SendMsgRocket getInstance() {
        if (INSTANCE == null) {
            Object object = lockobj;
            synchronized (object) {
                if (INSTANCE == null) {
                    SendMsgRocket tempobj = new SendMsgRocket();
                    try {
                        tempobj.producer = new DefaultMQProducer(Conf.get("rocketmq.server.defaultgroup"));
                        tempobj.producer.setInstanceName("MSG_SENDER-" + InetAddress.getLocalHost().getHostName());
                        tempobj.producer.setNamesrvAddr(Conf.get("rocketmq.server.namesrvaddr"));
                        tempobj.producer.start();
                        logger.info("MQ\u53d1\u9001\u7aef\u542f\u52a8\u6210\u529f");
                        INSTANCE = tempobj;
                    }
                    catch (Exception e) {
                        logger.error("MQ\u53d1\u9001\u7aef\u542f\u52a8\u5931\u8d25", (Throwable)e);
                        e.printStackTrace();
                    }
                }
            }
        }
        return INSTANCE;
    }

    private static void destroy() {
        if (INSTANCE != null && SendMsgRocket.INSTANCE.producer != null) {
            SendMsgRocket.INSTANCE.producer.shutdown();
            logger.info("[{}] metaq \u53d1\u9001\u7aef\u5173\u95ed\u6210\u529f.", (Object)Conf.get("rocketmq.server.namesrvaddr"));
        }
    }

    public SendResult SendMsg(String topic, String tag, String msg) {
        Message sendMsg = new Message(topic, tag, msg.getBytes());
        try {
            SendResult sendResult = this.producer.send(sendMsg);
            return sendResult;
        }
        catch (Exception e) {
            logger.error(String.format("\u53d1\u9001\u6d88\u606f\u5931\u8d25,\u6d88\u606f\uff1a[{}]", msg), (Throwable)e);
            return null;
        }
    }

    public SendResult SendMsg(String tag, String msg) {
        return this.SendMsg(Conf.get("rocketmq.server.defaulttopic"), tag, msg);
    }

    public SendResult SendMsg(String msg) {
        return this.SendMsg(Conf.get("rocketmq.server.defaulttopic"), Conf.get("rocketmq.server.defaulttag"), msg);
    }

    static {
        lockobj = new Object();
        Conf.addCallBack("rocket", new Conf.Callback(){

            @Override
            public void doReshConf(Properties newProperties) {
                SendMsgRocket.destroy();
                INSTANCE = null;
            }
        }, "rocketmq.server.%s");
    }
}

