/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.mq.rabbitmq;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.LogHelp;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;

public class ConnectionObj
implements ShutdownListener {
    private final Logger logger = LogHelp.getLogger(this.getClass());
    private static Object lockobj = new Object();
    private static volatile ConnectionObj INSTANCE;
    private Connection conn = null;
    private Channel channel = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ConnectionObj getInstance() {
        if (INSTANCE == null) {
            Object object = lockobj;
            synchronized (object) {
                if (INSTANCE == null) {
                    ConnectionObj tempobj = new ConnectionObj();
                    ConnectionFactory factory = new ConnectionFactory();
                    factory.setUsername(Conf.get("rabbitmq.server.username"));
                    factory.setPassword(Conf.get("rabbitmq.server.password"));
                    factory.setVirtualHost(Conf.get("rabbitmq.virtual.host"));
                    try {
                        Map<String, String> hostMap = Conf.getPre("rabbitmq.server.");
                        ArrayList<Address> hostlist = new ArrayList<Address>();
                        if (MapUtils.isEmpty(hostMap)) {
                            throw new IllegalArgumentException("rabbitmq\u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u5668\u5730\u5740");
                        }
                        Pattern pattern = Pattern.compile("rabbitmq\\.server\\.host.\\.ip");
                        for (String key : hostMap.keySet()) {
                            Matcher matcher = pattern.matcher(key);
                            if (!matcher.matches()) continue;
                            String ip = hostMap.get(key);
                            String port = hostMap.get(key.replace("ip", "port"));
                            hostlist.add(new Address(ip, Integer.parseInt(port)));
                        }
                        if (CollectionUtils.isEmpty(hostlist)) {
                            throw new IllegalArgumentException("rabbitmq\u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u5668\u5730\u5740");
                        }
                        tempobj.conn = factory.newConnection(hostlist.toArray(new Address[hostlist.size()]));
                        tempobj.conn.addShutdownListener((ShutdownListener)tempobj);
                        tempobj.channel = tempobj.conn.createChannel();
                        INSTANCE = tempobj;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return INSTANCE;
    }

    public void shutdownCompleted(ShutdownSignalException cause) {
        String exceptionMessage = cause.getMessage();
        this.logger.info("\u5ba2\u6237\u7aef\u5df2\u5173\u95ed\uff1a{}", (Object)exceptionMessage);
    }

    public Channel getChannel() {
        if (this.channel == null || !this.channel.isOpen()) {
            ConnectionObj.closeChannelAndConnection();
            return ConnectionObj.getInstance().channel;
        }
        return this.channel;
    }

    public static void closeChannelAndConnection() {
        if (INSTANCE != null) {
            if (ConnectionObj.INSTANCE.channel != null && ConnectionObj.INSTANCE.channel.isOpen()) {
                try {
                    ConnectionObj.INSTANCE.channel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (TimeoutException e) {
                    e.printStackTrace();
                }
            }
            if (ConnectionObj.INSTANCE.conn != null && ConnectionObj.INSTANCE.conn.isOpen()) {
                try {
                    ConnectionObj.INSTANCE.conn.removeShutdownListener((ShutdownListener)INSTANCE);
                    ConnectionObj.INSTANCE.conn.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            INSTANCE = null;
        }
    }
}

