/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.mq.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.ConsumerCancelledException;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.LogHelp;
import net.wicp.tams.commons.mq.rabbitmq.ConnectionObj;
import net.wicp.tams.commons.thread.ThreadPool;
import org.slf4j.Logger;

public class AcceptMsgRabbit
extends Observable {
    private final Logger logger = LogHelp.getLogger(this.getClass());
    public static final String DefaultTQuery = Conf.get("rabbitmq.server.default.queryname");
    private static Map<String, List<Observer>> obsmap = new HashMap<String, List<Observer>>();
    private static final AcceptMsgRabbit INSTANCE = new AcceptMsgRabbit();

    public static AcceptMsgRabbit getInstance() {
        return INSTANCE;
    }

    @Override
    public synchronized void addObserver(Observer observer) {
        this.addObserver(DefaultTQuery, observer);
    }

    public synchronized void addObserver(String queryName, Observer observer) {
        boolean needConsumer = false;
        if (obsmap.get(queryName) == null) {
            obsmap.put(queryName, new ArrayList());
            needConsumer = true;
        }
        this.addObserver(queryName, observer, needConsumer);
    }

    private void messageArrived(String tag, Object message) {
        for (Observer observer : obsmap.get(tag)) {
            observer.update(this, message);
        }
    }

    public synchronized void addObserver(final String queryName, Observer observer, boolean needConsumer) {
        if (obsmap.get(queryName) == null) {
            obsmap.put(queryName, new ArrayList());
        }
        obsmap.get(queryName).add(observer);
        if (needConsumer) {
            ThreadPool.getDefaultPool().submit(new Runnable(){

                @Override
                public void run() {
                    Channel channel = ConnectionObj.getInstance().getChannel();
                    try {
                        QueueingConsumer consumer = new QueueingConsumer(channel);
                        boolean autoAck = false;
                        channel.basicConsume(queryName, autoAck, (Consumer)consumer);
                        while (true) {
                            QueueingConsumer.Delivery delivery;
                            if ((delivery = consumer.nextDelivery(3000L)) == null) {
                                continue;
                            }
                            byte[] message = delivery.getBody();
                            try {
                                AcceptMsgRabbit.this.messageArrived(queryName, new String(message));
                                channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                            }
                            catch (Exception e) {
                                AcceptMsgRabbit.this.logger.error("\u63a5\u6536\u6d88\u606f\u65f6\u5931\u8d25", (Throwable)e);
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (ShutdownSignalException e) {
                        ConnectionObj.closeChannelAndConnection();
                    }
                    catch (ConsumerCancelledException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        ConnectionObj.closeChannelAndConnection();
                    }
                }
            });
        }
    }
}

