/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.mq;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.apiext.StringUtil;
import org.apache.commons.collections.CollectionUtils;

public abstract class SqsUtil {
    private static AmazonSQS sqs = null;
    private static String defaultMqUrl = null;

    public static Result sendMessage(String mqName, String msg) {
        try {
            String url = StringUtil.isNull(mqName) ? defaultMqUrl : sqs.getQueueUrl(mqName).getQueueUrl();
            SendMessageResult rt = sqs.sendMessage(url, msg);
            Result retobj = Result.getSuc();
            retobj.setMessage(rt.getMessageId());
            return retobj;
        }
        catch (Exception e) {
            return Result.getError(e.getMessage());
        }
    }

    public static Result sendMessage(String msg) {
        return SqsUtil.sendMessage(null, msg);
    }

    public static List<String> receiveMessage(String mqName, int maxNumber, boolean isDel) {
        String url = StringUtil.isNull(mqName) ? defaultMqUrl : sqs.getQueueUrl(mqName).getQueueUrl();
        List msgs = sqs.receiveMessage(new ReceiveMessageRequest(url).withMaxNumberOfMessages(Integer.valueOf(maxNumber))).getMessages();
        ArrayList<String> retlist = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)msgs)) {
            for (Message msg : msgs) {
                retlist.add(msg.getBody());
                if (!isDel) continue;
                sqs.deleteMessage(new DeleteMessageRequest(url, msg.getReceiptHandle()));
            }
        }
        return retlist;
    }

    public static List<String> receiveMessage(int maxNumber, boolean isDel) {
        return SqsUtil.receiveMessage(null, maxNumber, isDel);
    }

    public static String receiveMessageForOne(boolean isDel) {
        List<String> retlist = SqsUtil.receiveMessage(null, 1, isDel);
        return CollectionUtils.isEmpty(retlist) ? null : retlist.get(0);
    }

    static {
        String accessId = Conf.get("aws_access_key_id");
        String accessPwd = Conf.get("aws_secret_access_key");
        String defaultq = Conf.get("aws_defaultq");
        sqs = new AmazonSQSClient((AWSCredentials)new BasicAWSCredentials(accessId, accessPwd));
        Region usWest2 = Region.getRegion((Regions)Regions.CN_NORTH_1);
        sqs.setRegion(usWest2);
        defaultMqUrl = sqs.getQueueUrl(defaultq).getQueueUrl();
        Conf.addCallBack("SQS", new Conf.Callback(){

            @Override
            public void doReshConf(Properties newProperties) {
                String curKeyIdNew = newProperties.getProperty("aws_access_key_id");
                String curkeyNew = newProperties.getProperty("aws_access_key_id");
                String defaultqNew = newProperties.getProperty("aws_defaultq");
                sqs = (AmazonSQS)new AmazonSQSClient((AWSCredentials)new BasicAWSCredentials(curKeyIdNew, curkeyNew));
                defaultMqUrl = sqs.getQueueUrl(defaultqNew).getQueueUrl();
            }
        }, "aws_access_key_id", "aws_secret_access_key", "aws_defaultq");
    }
}

