/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.hibernate.service.impl;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.wicp.tams.commons.LogHelp;
import net.wicp.tams.commons.hibernate.service.IHbService;
import net.wicp.tams.commons.web.PageAssist;
import net.wicp.tams.commons.web.service.IPageBuild;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.Criteria;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Projections;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.AbstractQueryImpl;
import org.slf4j.Logger;

public class HbService
implements IHbService {
    private final Logger logger = LogHelp.getLogger(this.getClass());
    private SessionFactory sessionFactory;
    private IPageBuild pageBuild;

    @Override
    public <T extends Serializable> T findById(Class clazz, Serializable id) {
        return (T)((Serializable)this.getSession().get(clazz, id));
    }

    @Override
    public void delById(Class clazz, Serializable entityId) {
        Object entity = this.getSession().get(clazz, entityId);
        Preconditions.checkState((entity != null ? 1 : 0) != 0);
        this.getSession().delete(entity);
    }

    @Override
    public <T extends Serializable> void saveOrUpdate(T obj) {
        this.getSession().saveOrUpdate(obj);
    }

    @Override
    public <T extends Serializable> void attachLock(T entity) {
        try {
            this.getSession().buildLockRequest(LockOptions.UPGRADE).lock(entity);
        }
        catch (RuntimeException re) {
            this.logger.error("attach failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public Query getQuery(String hql) {
        return this.getSession().createQuery(hql);
    }

    @Override
    public Query getQuerySQL(String sql) {
        return this.getSession().createSQLQuery(sql);
    }

    @Override
    public <T extends Serializable> List<T> findByExample(T entity, Example.PropertySelector selector) {
        try {
            Example example = Example.create(entity).excludeZeroes();
            if (selector != null) {
                example.setPropertySelector(selector);
            }
            List results = this.getSession().createCriteria(entity.getClass()).add((Criterion)example).list();
            return results;
        }
        catch (RuntimeException re) {
            this.logger.error("find by example failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public <T extends Serializable> List<T> findByExample(T entity, String ... excludes) {
        try {
            Example example = Example.create(entity).excludeZeroes();
            if (ArrayUtils.isNotEmpty((Object[])excludes)) {
                for (String proName : excludes) {
                    example.excludeProperty(proName);
                }
            }
            List results = this.getSession().createCriteria(entity.getClass()).add((Criterion)example).list();
            return results;
        }
        catch (RuntimeException re) {
            this.logger.error("find by example failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public PageAssist findByCriteriaPage(Criteria criteria, PageAssist pageAssist) {
        PageAssist pageAssistTrue;
        PageAssist pageAssist2 = pageAssistTrue = pageAssist == null ? this.pageBuild.build() : pageAssist;
        if (pageAssistTrue.getAllNum() < 0L) {
            long totalCount = (Long)criteria.setProjection(Projections.rowCount()).uniqueResult();
            pageAssistTrue.setAllNum(totalCount);
            criteria.setProjection(null);
        }
        List retlist = this.findByCriteriaPage(criteria, pageAssistTrue.getPageNo(), pageAssistTrue.getPageSize());
        pageAssistTrue.setResult(retlist);
        return pageAssistTrue;
    }

    @Override
    public PageAssist findByCriteriaPage(Criteria criteria, HttpServletRequest request) {
        PageAssist init = this.pageBuild.build(request);
        return this.findByCriteriaPage(criteria, init);
    }

    @Override
    public PageAssist findByCriteriaPage(Criteria criteria) {
        PageAssist init = this.pageBuild.build();
        return this.findByCriteriaPage(criteria, init);
    }

    @Override
    public PageAssist findByQueryPage(Query queryparam, PageAssist pageAssistparam) {
        PageAssist pageAssistTrue = pageAssistparam == null ? this.pageBuild.build() : pageAssistparam;
        int pageSize = pageAssistTrue.getPageSize();
        int pageNo = pageAssistTrue.getPageNo();
        long allNum = pageAssistTrue.getAllNum();
        Preconditions.checkState((queryparam != null && pageNo > 0 && pageSize > 0 ? 1 : 0) != 0);
        AbstractQueryImpl queryAbs = (AbstractQueryImpl)queryparam;
        if (allNum < 0L) {
            String queryStr = queryparam.getQueryString();
            int firstIndex = queryStr.indexOf(" from");
            String queryCountSql = "select COUNT(-1)  " + queryStr.substring(firstIndex);
            Query countQuery = this.getSession().createQuery(queryCountSql);
            try {
                if (ArrayUtils.isNotEmpty((Object[])queryAbs.getNamedParameters())) {
                    Map paramMap = (Map)PropertyUtils.getProperty((Object)queryAbs, (String)"namedParameters");
                    for (String paramName : queryAbs.getNamedParameters()) {
                        TypedValue tempobj = (TypedValue)paramMap.get(paramName);
                        countQuery.setParameter(paramName, tempobj.getValue(), tempobj.getType());
                    }
                } else {
                    List values = (List)PropertyUtils.getProperty((Object)queryAbs, (String)"values");
                    for (int i = 0; i < values.size(); ++i) {
                        countQuery.setParameter(i + 1, values.get(i));
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Query\u5728\u7ffb\u9875\u65f6\u67e5\u8be2\u603b\u8bb0\u5f55\u6570\u51fa\u9519\u3002", (Throwable)e);
            }
            allNum = (Long)countQuery.uniqueResult();
            pageAssistTrue.setAllNum(allNum);
        }
        int startRes = pageSize * (pageNo - 1);
        int endRes = (int)(allNum > 0L && allNum < (long)(pageSize * pageNo) ? allNum : (long)(pageSize * pageNo));
        queryparam.setFirstResult(startRes).setMaxResults(endRes);
        List queryList = queryparam.list();
        pageAssistTrue.setResult(queryList);
        return pageAssistTrue;
    }

    @Override
    public PageAssist findByQueryPage(Query queryparam) {
        return this.findByQueryPage(queryparam, null);
    }

    @Override
    public Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    private final <T extends Serializable> List<T> findByCriteriaPage(Criteria criteria, int pageNo, int pageSize) {
        Preconditions.checkState((criteria != null && pageNo > 0 && pageSize > 0 ? 1 : 0) != 0);
        int min = (pageNo - 1) * pageSize;
        criteria.setFirstResult(min).setMaxResults(pageSize);
        return criteria.list();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public IPageBuild getPageBuild() {
        return this.pageBuild;
    }

    public void setPageBuild(IPageBuild pageBuild) {
        this.pageBuild = pageBuild;
    }
}

