/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.connector.beans.property;

import net.wicp.tams.commons.LogHelp;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.connector.beans.property.BasicHandler;
import net.wicp.tams.commons.constant.ColProperty;
import net.wicp.tams.commons.exception.ExceptAll;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class EnumHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogHelp.getLogger(EnumHandler.class);
    private Class beanClass;

    public EnumHandler(String name, Class type, Class contentType) {
        super(name, type, contentType);
        this.beanClass = contentType;
    }

    public EnumHandler(String name, Class type) {
        super(name, type);
        this.beanClass = type;
    }

    @Override
    protected Result checkSingleValue(Object value) {
        if (value.getClass().isAssignableFrom(this.beanClass)) {
            return Result.getSuc();
        }
        logger.error("[{}]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662f[{}],\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[{}]\u57fa\u672c\u7c7b\u578b", new Object[]{this.name, this.beanClass.getName(), value.getClass().getName()});
        return new Result(ExceptAll.Param_typenofit);
    }

    @Override
    protected Object singleObjToJson(Object singleValue) {
        Enum tempobj = (Enum)singleValue;
        return tempobj.name();
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        return Enum.valueOf(this.beanClass, (String)obj);
    }

    @Override
    public Object getSingleDefaultColValue() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isBlank((String)defaultValue)) {
            return null;
        }
        return Enum.valueOf(this.beanClass, defaultValue);
    }
}

