/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.connector.beans.property;

import java.util.HashMap;
import net.wicp.tams.commons.LogHelp;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.connector.beans.CusDynaBean;
import net.wicp.tams.commons.connector.beans.CusDynaClass;
import net.wicp.tams.commons.connector.beans.property.AbstractDynaClassProperty;
import net.wicp.tams.commons.connector.beans.property.BasicNoHandler;
import net.wicp.tams.commons.constant.ColProperty;
import net.wicp.tams.commons.exception.ExceptAll;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.json.JSONObject;
import org.slf4j.Logger;

public class DynaBeanHandler
extends BasicNoHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogHelp.getLogger(DynaBeanHandler.class);
    private CusDynaClass valueClass;

    public CusDynaClass getValueClass() {
        return this.valueClass;
    }

    public DynaBeanHandler(String name, DynaClass valueClass) {
        super(name, valueClass);
        this.valueClass = (CusDynaClass)valueClass;
    }

    public DynaBeanHandler(String name, Class type, DynaClass valueClass) {
        super(name, type, valueClass.getClass());
        this.valueClass = (CusDynaClass)valueClass;
    }

    @Override
    protected Result checkSingleValue(Object value) {
        String strict = this.getAttributeValue(ColProperty.strict);
        boolean isStrict = true;
        if (StringUtils.isNotBlank((String)strict)) {
            isStrict = Boolean.parseBoolean(strict);
        }
        boolean isSame = false;
        isSame = isStrict ? ((CusDynaBean)((Object)value)).getDynaClass() != this.valueClass : this.isSameClass(value);
        if (!isSame) {
            logger.error("[{}]\u7684\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5e94\u8be5\u662fCusDynaClass,\u4f46\u4f20\u8fdb\u6765\u7684\u53c2\u6570\u662f[{}]\u7c7b\u578b", (Object)this.name, (Object)value.getClass().getName());
            return new Result(ExceptAll.Param_typenofit);
        }
        return Result.getSuc();
    }

    private boolean isSameClass(Object value) {
        HashMap<String, AbstractDynaClassProperty> thisProps = this.valueClass.getAllPropertys();
        AbstractDynaClassProperty[] valProps = ((CusDynaBean)((Object)value)).getDynaClass().getDynaProperties();
        if (thisProps.size() != valProps.length) {
            return false;
        }
        boolean ret = true;
        for (AbstractDynaClassProperty valprop : valProps) {
            if (thisProps.keySet().contains(valprop.getName())) continue;
            ret = false;
            break;
        }
        return ret;
    }

    @Override
    protected Object jsonTosingleObj(Object obj) {
        JSONObject retobj = (JSONObject)obj;
        CusDynaBean dynabean = this.valueClass.newInstance();
        for (String key : retobj.keys()) {
            AbstractDynaClassProperty prop = (AbstractDynaClassProperty)dynabean.getDynaClass().getDynaProperty(key);
            if (prop == null) continue;
            prop.setValueByJson(dynabean, retobj.get(key));
        }
        return dynabean;
    }

    @Override
    public Object getSingleDefaultColValue() {
        String defaultValue = this.getAttriValue(ColProperty.defaultValue);
        if (StringUtils.isNotBlank((String)defaultValue)) {
            JSONObject json = new JSONObject(defaultValue);
            CusDynaBean db = (CusDynaBean)((Object)this.jsonTosingleObj(json));
            return db;
        }
        return null;
    }

    @Override
    protected Object singleObjToJson(Object singleValue) {
        AbstractDynaClassProperty[] props;
        if (singleValue == null) {
            return null;
        }
        JSONObject retobj = new JSONObject();
        CusDynaBean cus = (CusDynaBean)((Object)singleValue);
        for (AbstractDynaClassProperty prop : props = cus.getDynaClass().getDynaProperties()) {
            Object propValue = cus.get(prop.getName());
            retobj.put(prop.getName(), prop.singleObjToJson(propValue));
        }
        return retobj;
    }
}

