/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.connector.beans.property;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.commons.LogHelp;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.callback.impl.optGType.OptAbsGType;
import net.wicp.tams.commons.connector.beans.CusDynaBean;
import net.wicp.tams.commons.connector.beans.property.BasicHandler;
import net.wicp.tams.commons.constant.ColGType;
import net.wicp.tams.commons.constant.ColProperty;
import net.wicp.tams.commons.constant.ColType;
import net.wicp.tams.commons.exception.ExceptAll;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.slf4j.Logger;

public abstract class AbstractDynaClassProperty
extends DynaProperty
implements Cloneable {
    private static final long serialVersionUID = -5474164260071583692L;
    private static final Logger logger = LogHelp.getLogger(AbstractDynaClassProperty.class);
    protected final Map<ColProperty, String> attributes = new HashMap<ColProperty, String>();

    public AbstractDynaClassProperty(String name) {
        super(name);
    }

    public AbstractDynaClassProperty(String name, Class type) {
        super(name, type);
    }

    public AbstractDynaClassProperty(String name, Class type, Class contentType) {
        super(name, type, contentType);
    }

    protected abstract Result checkSingleValue(Object var1);

    public Result checkValue(Object value) {
        CheckPropertyValue checkobj = new CheckPropertyValue();
        Result result = checkobj.opt(this.getGType(), value);
        return result;
    }

    protected abstract Object singleObjToJson(Object var1);

    protected abstract Object jsonTosingleObj(Object var1);

    public JSONObject getJsonObj(CusDynaBean dynaBean) {
        PackJson packobj = new PackJson();
        Result res = packobj.opt(this.getGType(), new Object[]{dynaBean});
        Object retobj = null;
        if (res.isSuc()) {
            retobj = res.getRetObj(0);
            return new JSONObject(new Object[]{this.name, retobj});
        }
        return null;
    }

    public void setValueByJson(CusDynaBean dynaBean, Object json) {
        PutJson putobj = new PutJson(json);
        Result res = putobj.opt(this.getGType(), new Object[]{dynaBean});
        if (!res.isSuc()) {
            logger.error("\u8bbe\u7f6e\u52a8\u6001Bean\u503c\u51fa\u9519\uff0c\u539f\u56e0\uff1a{}", (Object)res.getMessage());
        }
    }

    public abstract Object getSingleDefaultColValue();

    public void setDefaultColValue(CusDynaBean dynaBean) {
        Object defaultValue;
        if (StringUtils.isNotBlank((String)this.getAttriValue(ColProperty.defaultValue)) && this.getGType() == ColGType.single && (defaultValue = this.getSingleDefaultColValue()) != null) {
            dynaBean.set(this.name, defaultValue);
        }
    }

    public String getAttriValue(ColProperty attname) {
        if (attname == null) {
            return null;
        }
        return this.attributes.get((Object)attname);
    }

    public ColGType getGType() {
        String gType = this.getAttriValue(ColProperty.gtype);
        return ColGType.getByName(gType);
    }

    public boolean isNull() {
        String isnullStr = this.getAttriValue(ColProperty.isnull);
        return Boolean.parseBoolean(isnullStr);
    }

    public void putAttributes(Map<ColProperty, String> attributes) {
        this.attributes.putAll(attributes);
    }

    public void putAttribute(ColProperty colProperty, String value) {
        if (colProperty == null) {
            return;
        }
        this.attributes.put(colProperty, value);
    }

    public void putAttribute(String attname, String value) {
        ColProperty findCol = ColProperty.getByName(attname);
        this.putAttribute(findCol, value);
    }

    public Map<ColProperty, String> getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(ColProperty attname) {
        if (attname == null) {
            return null;
        }
        return this.attributes.get((Object)attname);
    }

    public String getAttributeValue(String attname) {
        ColProperty findCol = ColProperty.getByName(attname);
        return this.getAttributeValue(findCol);
    }

    private class PutJson
    extends OptAbsGType {
        private final Object obj;

        public PutJson(Object json) {
            this.obj = json instanceof BasicHandler ? json : json;
        }

        @Override
        protected Result doSingle(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(this.obj);
            inputBean.set(AbstractDynaClassProperty.this.name, valobj);
            return Result.getSuc();
        }

        @Override
        protected Result doArray(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            JSONArray arry = (JSONArray)this.obj;
            Object[] retAry = new Object[arry.length()];
            for (int i = 0; i < retAry.length; ++i) {
                Object valobj;
                retAry[i] = valobj = AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
            }
            inputBean.set(AbstractDynaClassProperty.this.name, retAry);
            return Result.getSuc();
        }

        @Override
        protected Result doMap(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            JSONObject json = (JSONObject)this.obj;
            for (String key : json.keys()) {
                Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(json.get(key));
                inputBean.set(AbstractDynaClassProperty.this.name, key, valobj);
            }
            return Result.getSuc();
        }

        @Override
        protected Result doList(Object param) {
            CusDynaBean inputBean = (CusDynaBean)((Object)param);
            JSONArray arry = (JSONArray)this.obj;
            for (int i = 0; i < arry.length(); ++i) {
                Object valobj = AbstractDynaClassProperty.this.jsonTosingleObj(arry.get(i));
                inputBean.set(AbstractDynaClassProperty.this.name, i, valobj);
            }
            return Result.getSuc();
        }
    }

    private class PackJson
    extends OptAbsGType {
        private PackJson() {
        }

        @Override
        protected Result doSingle(Object param) {
            if (param == null) {
                return Result.getError("\u7a7a\u503c");
            }
            CusDynaBean dynaBean = (CusDynaBean)((Object)param);
            Object retobj = AbstractDynaClassProperty.this.singleObjToJson(dynaBean.get(AbstractDynaClassProperty.this.name));
            if (retobj == null) {
                return Result.getError("\u7a7a\u503c");
            }
            Result ret = Result.getSuc();
            ret.setRetObjs(retobj);
            return ret;
        }

        @Override
        protected Result doArray(Object param) {
            if (param == null) {
                return Result.getError("\u7a7a\u503c");
            }
            CusDynaBean dynaBean = (CusDynaBean)((Object)param);
            Object[] objary = (Object[])dynaBean.get(AbstractDynaClassProperty.this.name);
            if (objary == null || objary.length == 0) {
                return Result.getError("\u7a7a\u503c");
            }
            JSONArray retary = new JSONArray();
            for (Object object : objary) {
                Object retobj = null;
                retobj = object instanceof CusDynaBean ? AbstractDynaClassProperty.this.singleObjToJson(object) : String.valueOf(object);
                retary.put(retobj);
            }
            Result ret = Result.getSuc();
            ret.setRetObjs(retary);
            return ret;
        }

        @Override
        protected Result doMap(Object param) {
            if (param == null) {
                return Result.getError("\u7a7a\u503c");
            }
            CusDynaBean dynaBean = (CusDynaBean)((Object)param);
            Map objmap = (Map)dynaBean.get(AbstractDynaClassProperty.this.name);
            if (MapUtils.isEmpty((Map)objmap)) {
                return Result.getError("\u7a7a\u503c");
            }
            JSONObject retobj = new JSONObject();
            for (Object key : objmap.keySet()) {
                if (objmap.get(key) instanceof CusDynaBean) {
                    retobj.put(String.valueOf(key), AbstractDynaClassProperty.this.singleObjToJson(objmap.get(key)));
                    continue;
                }
                retobj.put(String.valueOf(key), (Object)String.valueOf(objmap.get(key)));
            }
            Result ret = Result.getSuc();
            ret.setRetObjs(retobj);
            return ret;
        }

        @Override
        protected Result doList(Object param) {
            if (param == null) {
                return Result.getError("\u7a7a\u503c");
            }
            CusDynaBean dynaBean = (CusDynaBean)((Object)param);
            List objlist = (List)dynaBean.get(AbstractDynaClassProperty.this.name);
            if (CollectionUtils.isEmpty((Collection)objlist)) {
                return Result.getError("\u7a7a\u503c");
            }
            JSONArray retobj = new JSONArray();
            for (Object object : objlist) {
                if (object instanceof CusDynaBean) continue;
                retobj.put((Object)String.valueOf(object));
            }
            Result ret = Result.getSuc();
            ret.setRetObjs(retobj);
            return ret;
        }
    }

    private class CheckPropertyValue
    extends OptAbsGType {
        int length;

        private CheckPropertyValue() {
            this.length = StringUtils.isBlank((String)AbstractDynaClassProperty.this.getAttriValue(ColProperty.length)) ? -1 : Integer.parseInt(AbstractDynaClassProperty.this.getAttriValue(ColProperty.length));
        }

        @Override
        protected Result doSingle(Object param) {
            return AbstractDynaClassProperty.this.checkSingleValue(param);
        }

        @Override
        protected Result doArray(Object param) {
            if (param != null && !param.getClass().isArray() || ColType.bytes.name().equals(AbstractDynaClassProperty.this.getAttriValue(ColProperty.type)) && param.getClass().isAssignableFrom(byte[].class)) {
                return this.doSingle(param);
            }
            Object[] values = (Object[])param;
            if (this.length >= 0 && values.length > this.length) {
                logger.error("\u8d8a\u754c[{}]\u957f\u5ea6\u4e3a\uff1a{} \u4f46\u662f\u4f20\u8fdb\u6765\u7684\u503c\u5927\u5c0f\u4e3a\uff1a", new Object[]{AbstractDynaClassProperty.this.name, this.length, values.length});
                return new Result(ExceptAll.Param_lengthover);
            }
            StringBuffer retbuff = new StringBuffer("");
            for (int i = 0; i < values.length; ++i) {
                Result rs = AbstractDynaClassProperty.this.checkSingleValue(values[i]);
                if (rs.isSuc()) continue;
                retbuff.append(String.format("\u7b2c[%s]\u4e2a\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u56e0\uff1a%s\n", i + 1, rs.getMessage()));
            }
            return this.retValue(retbuff);
        }

        private Result retValue(StringBuffer retbuff) {
            if (StringUtils.isBlank((String)retbuff.toString())) {
                return Result.getSuc();
            }
            retbuff.insert(0, "\u68c0\u67e5\u9519\u8bef\uff0c\u539f\u56e0\uff1a");
            return Result.getError(retbuff.toString());
        }

        @Override
        protected Result doMap(Object param) {
            if (!Map.class.isAssignableFrom(param.getClass())) {
                return this.doSingle(param);
            }
            Map tempValue = (Map)param;
            if (this.length >= 0 && tempValue.size() > this.length) {
                logger.error("\u8d8a\u754c[{}]\u957f\u5ea6\u4e3a\uff1a{} \u4f46\u662f\u4f20\u8fdb\u6765\u7684\u503c\u5927\u5c0f\u4e3a\uff1a", new Object[]{AbstractDynaClassProperty.this.name, this.length, tempValue.size()});
                return new Result(ExceptAll.Param_lengthover);
            }
            StringBuffer retbuff = new StringBuffer("");
            for (String eleKey : tempValue.keySet()) {
                Result rs = AbstractDynaClassProperty.this.checkSingleValue(tempValue.get(eleKey));
                if (rs.isSuc()) continue;
                retbuff.append(String.format("\u53c2\u6570\uff1a{} \u4e0d\u5408\u6cd5\uff0c\u539f\u56e0\uff1a{},", eleKey, rs.getMessage()));
            }
            return this.retValue(retbuff);
        }

        @Override
        protected Result doList(Object param) {
            if (!List.class.isAssignableFrom(param.getClass())) {
                return this.doSingle(param);
            }
            List tempValue = (List)param;
            if (this.length >= 0 && tempValue.size() > this.length) {
                logger.error("\u8d8a\u754c[{}]\u957f\u5ea6\u4e3a\uff1a{} \u4f46\u662f\u4f20\u8fdb\u6765\u7684\u503c\u5927\u5c0f\u4e3a\uff1a", new Object[]{AbstractDynaClassProperty.this.name, this.length, tempValue.size()});
                return new Result(ExceptAll.Param_lengthover);
            }
            StringBuffer retbuff = new StringBuffer("");
            for (int i = 0; i < tempValue.size(); ++i) {
                Object object = tempValue.get(i);
                Result rs = AbstractDynaClassProperty.this.checkSingleValue(object);
                if (rs.isSuc()) continue;
                retbuff.append(String.format("\u7b2c{}\u4e2a\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u539f\u56e0\uff1a{},", i + 1, rs.getMessage()));
            }
            return this.retValue(retbuff);
        }
    }
}

