/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.connector.beans;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.commons.LogHelp;
import net.wicp.tams.commons.Result;
import net.wicp.tams.commons.callback.impl.optGType.OptAbsGType;
import net.wicp.tams.commons.connector.beans.CusDynaClass;
import net.wicp.tams.commons.connector.beans.property.AbstractDynaClassProperty;
import net.wicp.tams.commons.connector.beans.property.BasicHandler;
import net.wicp.tams.commons.connector.beans.property.BytesHandler;
import net.wicp.tams.commons.connector.beans.property.DynaBeanHandler;
import net.wicp.tams.commons.connector.beans.property.JavaBeanHandler;
import net.wicp.tams.commons.constant.ColGType;
import net.wicp.tams.commons.exception.ExceptAll;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.lang.ArrayUtils;
import org.apache.tapestry5.json.JSONObject;
import org.slf4j.Logger;

public class CusDynaBean
extends BasicDynaBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogHelp.getLogger(CusDynaBean.class);

    public CusDynaBean(DynaClass dynaClass) {
        super(dynaClass);
        if (dynaClass != null) {
            this.dynaClass = (CusDynaClass)dynaClass;
            this.setDefaultColValue();
        }
    }

    public CusDynaClass getDynaClass() {
        return (CusDynaClass)this.dynaClass;
    }

    public Object getByAliasName(String aliasName) {
        AbstractDynaClassProperty col = ((CusDynaClass)this.dynaClass).findPropertyByAlais(aliasName);
        if (col != null) {
            return super.get(col.getName());
        }
        return null;
    }

    public String getStrValueByName(String name) {
        AbstractDynaClassProperty col = this.getDynaClass().findProperty(name);
        JSONObject json = col.getJsonObj(this);
        if (col instanceof BasicHandler || col instanceof BytesHandler) {
            if (json == null) {
                return "";
            }
            return json.getString(name);
        }
        if (json == null) {
            return "{}";
        }
        return json.getJSONObject(name).toString(true);
    }

    public void set(String name, Object value) {
        AbstractDynaClassProperty prop = (AbstractDynaClassProperty)this.dynaClass.getDynaProperty(name);
        this.checkValue(name, value, prop);
        PackObject packObject = new PackObject(prop);
        Result ret = packObject.opt(prop.getGType(), value);
        if (!ret.isSuc()) {
            throw new IllegalArgumentException(String.format("\u5bf9\u5c5e\u6027%s\u8bbe\u7f6e\u503c%s\u5931\u8d25", name, value));
        }
    }

    public void set(String name, int index, Object value) {
        AbstractDynaClassProperty prop = (AbstractDynaClassProperty)this.dynaClass.getDynaProperty(name);
        if (prop.getGType() != ColGType.array && prop.getGType() != ColGType.list) {
            logger.error("\u5c5e\u6027[{}]\u8981\u6c42array\u6216list\u7c7b\u578b\uff0c\u4e0d\u9002\u5408\u6b64\u65b9\u6cd5", (Object)name);
            throw new IllegalArgumentException("\u8981\u6c42List\u7c7b\u578b");
        }
        this.checkValue(name, value, prop);
        super.set(name, index, value);
    }

    public void set(String name, String key, Object value) {
        AbstractDynaClassProperty prop = (AbstractDynaClassProperty)this.dynaClass.getDynaProperty(name);
        if (prop.getGType() != ColGType.map) {
            logger.error("\u5c5e\u6027[{}]\u8981\u6c42Map\u7c7b\u578b\uff0c\u4e0d\u9002\u5408\u6b64\u65b9\u6cd5", (Object)name);
            throw new IllegalArgumentException("\u8981\u6c42Map\u7c7b\u578b");
        }
        this.checkValue(name, value, prop);
        super.set(name, key, value);
    }

    public JSONObject getJsonObj() {
        AbstractDynaClassProperty[] props;
        JSONObject retobj = new JSONObject();
        for (AbstractDynaClassProperty prop : props = ((CusDynaClass)this.dynaClass).getDynaProperties()) {
            JSONObject tempjson = prop.getJsonObj(this);
            if (tempjson == null) continue;
            retobj.put(prop.getName(), tempjson.get(prop.getName()));
        }
        return retobj;
    }

    public void setByJson(JSONObject obj) {
        if (obj == null || obj.length() == 0) {
            return;
        }
        HashMap<String, AbstractDynaClassProperty> propmap = ((CusDynaClass)this.dynaClass).getAllPropertys();
        for (String key : obj.keys()) {
            AbstractDynaClassProperty prop = propmap.get(key);
            ColGType gtype = prop.getGType();
            if (prop == null) continue;
            switch (gtype) {
                case single: {
                    if (prop instanceof BasicHandler) {
                        prop.setValueByJson(this, obj.getString(key));
                        break;
                    }
                    prop.setValueByJson(this, obj.getJSONObject(key));
                    break;
                }
                case array: 
                case list: {
                    prop.setValueByJson(this, obj.getJSONArray(key));
                    break;
                }
                case map: {
                    prop.setValueByJson(this, obj.getJSONObject(key));
                }
            }
        }
    }

    public CusDynaClass copyClass() {
        try {
            return ((CusDynaClass)this.dynaClass).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("\u514b\u9686\u5931\u8d25");
        }
    }

    public CusDynaBean clone() {
        try {
            return (CusDynaBean)((Object)super.clone());
        }
        catch (CloneNotSupportedException e) {
            logger.error("\u514b\u9686");
            return null;
        }
    }

    private void parentSet(String name, Object value) {
        super.set(name, value);
    }

    public CusDynaBean newCusDynaBean(String name, boolean saveDefault) {
        AbstractDynaClassProperty prop = (AbstractDynaClassProperty)this.dynaClass.getDynaProperty(name);
        if (prop instanceof DynaBeanHandler) {
            CusDynaBean retobj;
            if (saveDefault && (retobj = (CusDynaBean)((Object)prop.getSingleDefaultColValue())) != null) {
                return retobj;
            }
            DynaBeanHandler optClass = (DynaBeanHandler)prop;
            CusDynaBean retBean = new CusDynaBean((DynaClass)optClass.getValueClass());
            return retBean;
        }
        logger.error("\u65b9\u6cd5[newCusDynaBean]\u53ea\u652f\u6301DynaBeanHandler\u7684\u7c7b\u578b");
        throw new IllegalArgumentException("\u65b9\u6cd5[newCusDynaBean]\u53ea\u652f\u6301DynaBeanHandler\u7684\u7c7b\u578b");
    }

    public CusDynaBean newCusDynaBean(String name) {
        return this.newCusDynaBean(name, true);
    }

    public Object newDefaultObj(String name) {
        AbstractDynaClassProperty prop = (AbstractDynaClassProperty)this.dynaClass.getDynaProperty(name);
        if (prop instanceof JavaBeanHandler) {
            return prop.getSingleDefaultColValue();
        }
        logger.error("\u65b9\u6cd5[newDefaultObj]\u53ea\u652f\u6301JavaBeanHandler\u7684\u7c7b\u578b");
        throw new IllegalArgumentException("\u65b9\u6cd5[newDefaultObj]\u53ea\u652f\u6301JavaBeanHandler\u7684\u7c7b\u578b");
    }

    private void checkValue(String name, Object value, AbstractDynaClassProperty prop) {
        if (prop == null) {
            throw new IllegalArgumentException(String.format("\u4e0d\u5b58\u5728\u540d\u4e3a[%s]\u7684\u53c2\u6570\u3002", name));
        }
        Result checkRest = prop.checkValue(value);
        if (!checkRest.isSuc()) {
            throw new IllegalArgumentException(String.format("\u53c2\u6570[%s]\u68c0\u67e5\u4e0d\u901a\u8fc7,%s", name, checkRest.getMessage()));
        }
    }

    private void setDefaultColValue() {
        if (this.dynaClass == null) {
            return;
        }
        Object[] allProperty = ((CusDynaClass)this.dynaClass).getDynaProperties();
        if (ArrayUtils.isNotEmpty((Object[])allProperty)) {
            for (Object abstractDynaClassProperty : allProperty) {
                ((AbstractDynaClassProperty)abstractDynaClassProperty).setDefaultColValue(this);
            }
        }
    }

    private class PackObject
    extends OptAbsGType {
        private final AbstractDynaClassProperty prop;

        public PackObject(AbstractDynaClassProperty prop) {
            this.prop = prop;
        }

        @Override
        protected Result doSingle(Object param) {
            if (this.prop instanceof BytesHandler) {
                if (param.getClass().isAssignableFrom(byte[].class)) {
                    CusDynaBean.this.parentSet(this.prop.getName(), param);
                } else if (param.getClass().isAssignableFrom(byte[][].class)) {
                    logger.warn("\u5c5e\u6027[{}]\u5728\u53c2\u6570\u5b9a\u4e49\u4e2d\u4e3a\u5355\u503c\u5bf9\u8c61.\u4f46\u5728\u63a5\u53d7\u53c2\u6570\u4e2d\u5374\u53c8\u591a\u4e2a\u503c,\u7cfb\u7edf\u5c06\u81ea\u52a8\u8fc7\u6ee4\u540e\u9762\u5f97\u503c", (Object)this.prop.getName());
                    byte[][] tempValue = (byte[][])param;
                    CusDynaBean.this.parentSet(this.prop.getName(), tempValue[0]);
                }
                return Result.getSuc();
            }
            if (param != null && param.getClass().isArray()) {
                logger.warn("\u5c5e\u6027[{}]\u5728\u53c2\u6570\u5b9a\u4e49\u4e2d\u4e3a\u5355\u503c\u5bf9\u8c61.\u4f46\u5728\u63a5\u53d7\u53c2\u6570\u4e2d\u5374\u53c8\u591a\u4e2a\u503c,\u7cfb\u7edf\u5c06\u81ea\u52a8\u8fc7\u6ee4\u540e\u9762\u5f97\u503c", (Object)this.prop.getName());
                Object[] tempValue = (Object[])param;
                CusDynaBean.this.parentSet(this.prop.getName(), tempValue[0]);
            } else {
                CusDynaBean.this.parentSet(this.prop.getName(), param);
            }
            return Result.getSuc();
        }

        @Override
        protected Result doArray(Object param) {
            if (this.prop instanceof BytesHandler) {
                if (param.getClass().isAssignableFrom(byte[].class)) {
                    CusDynaBean.this.parentSet(this.prop.getName(), new byte[][]{(byte[])param});
                } else if (param.getClass().isAssignableFrom(byte[][].class)) {
                    CusDynaBean.this.parentSet(this.prop.getName(), param);
                }
                return Result.getSuc();
            }
            if (param.getClass().isArray()) {
                CusDynaBean.this.parentSet(this.prop.getName(), param);
            } else {
                Object[] addValue = new Object[]{param};
                CusDynaBean.this.parentSet(this.prop.getName(), addValue);
            }
            return Result.getSuc();
        }

        @Override
        protected Result doMap(Object param) {
            if (Map.class.isAssignableFrom(param.getClass())) {
                CusDynaBean.this.parentSet(this.prop.getName(), param);
                return Result.getSuc();
            }
            logger.error("\u5c5e\u6027[{}]\u8981\u6c42Map\u7c7b\u578b\uff0c\u5374\u4f20\u6765\u6765{}\u7c7b\u578b", (Object)this.prop.getName(), param.getClass());
            return new Result(ExceptAll.Param_typenofit);
        }

        @Override
        protected Result doList(Object param) {
            if (List.class.isAssignableFrom(param.getClass())) {
                CusDynaBean.this.parentSet(this.prop.getName(), param);
                return Result.getSuc();
            }
            logger.error("\u5c5e\u6027[{}]\u8981\u6c42List\u7c7b\u578b\uff0c\u5374\u4f20\u6765\u6765{}\u7c7b\u578b", (Object)this.prop.getName(), param.getClass());
            return new Result(ExceptAll.Param_typenofit);
        }
    }
}

