/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Date;
import net.wicp.tams.commons.apiext.DateUtil;
import net.wicp.tams.commons.apiext.NumberUtil;
import net.wicp.tams.commons.callback.IValueEncoder;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

public abstract class StringUtil {
    public static final Format formatCommon = new Format(){
        private static final long serialVersionUID = -8271124584977967310L;

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return source;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(obj);
        }
    };

    public static boolean isNull(boolean NullIsTrue, Object inputObj) {
        if (inputObj == null) {
            return true;
        }
        String inputstr = StringUtil.trimSpace(String.valueOf(inputObj));
        if (NullIsTrue) {
            return inputstr.equalsIgnoreCase("null");
        }
        return StringUtils.isBlank((String)inputstr);
    }

    public static boolean isNull(Object inputObj) {
        return StringUtil.isNull(true, inputObj);
    }

    public static boolean isNotNull(Object inputObj) {
        return !StringUtil.isNull(true, inputObj);
    }

    public static String hasNull(boolean isDelNullStr, String ... inputStr) {
        String returnStr;
        if (inputStr == null) {
            return "";
        }
        switch (inputStr.length) {
            case 0: {
                returnStr = "";
                break;
            }
            case 1: {
                returnStr = StringUtil.trimSpace(inputStr[0]);
                break;
            }
            default: {
                returnStr = inputStr[0] == null || inputStr[0].trim().length() <= 0 ? StringUtil.trimSpace(inputStr[1]) : StringUtil.trimSpace(inputStr[0]);
            }
        }
        if (isDelNullStr) {
            returnStr = returnStr.equalsIgnoreCase("null") ? "" : returnStr;
        }
        return returnStr;
    }

    public static String hasNull(String ... inputStr) {
        return StringUtil.hasNull(true, inputStr);
    }

    public static String trimSpace(String str) {
        int first;
        if (str == null || str.trim().length() == 0) {
            return "";
        }
        int len = str.length();
        int last = str.length() - 1;
        char c = str.charAt(first);
        for (first = 0; first < len && (c == '\u3000' || c == ' '); ++first) {
            c = str.charAt(first);
        }
        if (first > 0) {
            --first;
        }
        if (len > 0) {
            c = str.charAt(last);
            while (last > 0 && (c == '\u3000' || c == ' ')) {
                c = str.charAt(--last);
            }
            ++last;
        }
        if (first >= last) {
            return "";
        }
        return first > 0 || last < len ? str.substring(first, last) : str;
    }

    public static String convertFenToYuan(String fen) {
        return StringUtil.convertFenToYuan(Double.parseDouble(fen));
    }

    public static String convertFenToYuan(double fen) {
        String result;
        try {
            double yuan = fen / 100.0;
            result = NumberUtil.handleScale(yuan, 2).toString();
        }
        catch (Exception ex) {
            result = "0.00";
        }
        return result;
    }

    public static int sumOfNumLet(String src) {
        String figures = "0123456789";
        String letters = "abcdefghijklmnopqrstuvwxyz";
        int sum = 0;
        for (int i = 0; src != null && i < src.length(); ++i) {
            char ch = src.charAt(i);
            if (figures.indexOf(ch) == -1 && letters.indexOf(ch) == -1) continue;
            ++sum;
        }
        return sum;
    }

    public static String toUpperCaseFirstOne(String s) {
        if (StringUtils.isBlank((String)s)) {
            return "";
        }
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static final <T> T str2Object(Class<T> type, String v, IValueEncoder<T> handler) {
        Object param = null;
        if (handler != null) {
            return handler.toValue(v);
        }
        if (type != String.class && StringUtils.isEmpty((String)v)) {
            return null;
        }
        if (type == String.class) {
            param = v;
        } else if (type == Integer.TYPE || type == Integer.class) {
            param = Integer.parseInt(v);
        } else if (type == Long.TYPE || type == Long.class) {
            param = Long.parseLong(v);
        } else if (type == Byte.TYPE || type == Byte.class) {
            param = Byte.parseByte(v);
        } else if (type == Character.TYPE || type == Character.class) {
            param = Character.valueOf(v.charAt(0));
        } else if (type == Float.TYPE || type == Float.class) {
            param = Float.valueOf(Float.parseFloat(v));
        } else if (type == Double.TYPE || type == Double.class) {
            param = Double.parseDouble(v);
        } else if (type == Short.TYPE || type == Short.class) {
            param = Short.parseShort(v);
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            param = Boolean.parseBoolean(v);
        } else if (Date.class.isAssignableFrom(type)) {
            param = DateUtil.objToDate(v);
        } else if (Enum.class.isAssignableFrom(type)) {
            try {
                param = type.getField(v).get(null);
            }
            catch (Exception e) {}
        } else if (type == BigDecimal.class) {
            try {
                param = new BigDecimal(v);
            }
            catch (Exception e) {}
        } else {
            throw new IllegalArgumentException(String.format("object type '%s' not valid", type));
        }
        return (T)param;
    }

    public static final <T> T str2Object(Class<T> type, String v) {
        return StringUtil.str2Object(type, v, null);
    }

    public static void packObj(Object retobj, String fieldName, String value) throws Exception {
        int indexdot = fieldName.indexOf(".");
        if (indexdot <= 0) {
            Field field = null;
            try {
                field = retobj.getClass().getDeclaredField(fieldName);
            }
            catch (Exception e) {
                return;
            }
            Class<?> fildeClass = field.getType();
            Object valueObj = StringUtil.str2Object(fildeClass, value);
            if (valueObj != null) {
                BeanUtils.setProperty((Object)retobj, (String)fieldName, valueObj);
            }
        } else {
            String fieldNameTrue = fieldName.substring(0, indexdot);
            Field field = null;
            try {
                field = retobj.getClass().getDeclaredField(fieldNameTrue);
            }
            catch (Exception e) {
                return;
            }
            Class<?> filedClass = field.getType();
            Object fieldvalue = filedClass.newInstance();
            StringUtil.packObj(fieldvalue, fieldName.substring(indexdot + 1), value);
            BeanUtils.setProperty((Object)retobj, (String)fieldNameTrue, fieldvalue);
        }
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(StringUtil.charToByte(hexChars[pos]) << 4 | StringUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

