/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.wicp.tams.commons.apiext.CollectionUtil;
import net.wicp.tams.commons.apiext.ReflectAssist;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.callback.IConvertValue;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.json.JSONObject;
import org.mvel2.templates.TemplateRuntime;

public abstract class JSONUtil {
    public static final String[][] specialChar = new String[][]{{"\\\\", "\\\\\\\\"}, {"\"null\"", "\"\""}};

    public static JSONObject mergeJSON(JSONObject res1, JSONObject res2) {
        JSONObject addJSON = res1.keys().size() < res2.keys().size() ? res1 : res2;
        JSONObject mainJSON = res1.keys().size() < res2.keys().size() ? res2 : res1;
        for (String key : addJSON.keys()) {
            mainJSON.append(key, addJSON.get(key));
        }
        return mainJSON;
    }

    public static List<String[]> getValues(JSONObject jsonObject) {
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        for (String key : jsonObject.keys()) {
            resultList.add(new String[]{key, String.valueOf(jsonObject.get(key))});
        }
        return resultList;
    }

    public static String getJsonForMap(Map<String, Object> fromMap, IConvertValue[] convert, String ... keys) {
        if (fromMap == null || fromMap.size() == 0) {
            return null;
        }
        keys = ArrayUtils.isNotEmpty((Object[])keys) ? keys : (String[])fromMap.keySet().toArray();
        StringBuffer buff = new StringBuffer("{");
        for (int i = 0; i < keys.length; ++i) {
            String valueTrue;
            String key = keys[i];
            String[] keyAry = key.split(",");
            String valCol = StringUtil.trimSpace(keyAry[0]);
            String showCol = StringUtil.trimSpace(keyAry[keyAry.length - 1]);
            Object value = fromMap.get(valCol);
            String string = valueTrue = value == null ? null : String.valueOf(value);
            if (convert != null && convert.length > i && convert[i] != null) {
                IConvertValue convertTrue = convert[i];
                String string2 = valueTrue = valueTrue == null ? "" : convertTrue.getStr(valueTrue);
            }
            if (i != 0) {
                buff.append(",");
            }
            buff.append("\"" + showCol + "\":\"" + StringUtil.hasNull(valueTrue) + "\"");
        }
        buff.append("}");
        return buff.toString();
    }

    public static String getJsonForMap(Map<String, Object> fromMap, String ... keys) {
        return JSONUtil.getJsonForMap(fromMap, null, keys);
    }

    public static String getJsonForList(List<?> fromList, IConvertValue[] converts, String ... titles) {
        if (CollectionUtils.isEmpty(fromList) || ArrayUtils.isEmpty((Object[])titles)) {
            return "[]";
        }
        StringBuffer buff = new StringBuffer("[");
        for (Object object : fromList) {
            if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
                String singJoson = JSONUtil.getJsonForMap((Map<String, Object>)((Map)object), converts, titles);
                buff.append(singJoson + ",");
                continue;
            }
            StringBuffer jsonTempStr = new StringBuffer("@{'{");
            for (int i = 0; i < titles.length; ++i) {
                String[] titleAry = titles[i].split(",");
                String valCol = StringUtil.trimSpace(titleAry[0]);
                String showCol = StringUtil.trimSpace(titleAry[titleAry.length - 1]);
                jsonTempStr.append("\"" + showCol + "\":\"'+" + valCol + "+'\"");
                if (i == titles.length - 1) continue;
                jsonTempStr.append(",");
            }
            jsonTempStr.append("}'}");
            String tempStr = String.valueOf(TemplateRuntime.eval((String)jsonTempStr.toString(), object));
            if (ArrayUtils.isNotEmpty((Object[])converts)) {
                JSONObject jsObj = new JSONObject(tempStr);
                for (int i = 0; i < converts.length; ++i) {
                    String colName;
                    IConvertValue convert = converts[i];
                    String string = colName = i < titles.length ? titles[i] : null;
                    if (convert == null || !StringUtils.isNotBlank((String)colName)) continue;
                    int index = colName.indexOf(",");
                    String key = "";
                    key = index > 0 ? colName.substring(index + 1) : colName;
                    String value = convert.getStr(jsObj.getString(key));
                    jsObj.put(key, (Object)value);
                }
                tempStr = jsObj.toString();
            }
            for (int i = 0; i < specialChar.length; ++i) {
                String[] tempAry = specialChar[i];
                tempStr = tempStr.replaceAll(tempAry[0], tempAry[1]);
            }
            buff.append(tempStr + ",");
        }
        buff.delete(buff.length() - 1, buff.length());
        buff.append("]");
        return buff.toString();
    }

    public static String getJsonForList(List<?> fromList, String ... titles) {
        return JSONUtil.getJsonForList(fromList, new IConvertValue[0], titles);
    }

    public static String getJsonForList(List<?> fromList, Map<String, IConvertValue> convertsMap, String ... titles) {
        IConvertValue[] convert = null;
        if (convertsMap != null && CollectionUtils.isNotEmpty(convertsMap.keySet())) {
            convert = new IConvertValue[titles.length];
            for (String title : convertsMap.keySet()) {
                int index = -1;
                for (int i = 0; i < titles.length; ++i) {
                    String trueKey;
                    String eleTitle = titles[i];
                    if (!StringUtils.isNotBlank((String)eleTitle)) continue;
                    String[] tempTitleAry = eleTitle.split(",");
                    String string = trueKey = tempTitleAry.length > 1 ? tempTitleAry[1] : tempTitleAry[0];
                    if (!title.equalsIgnoreCase(trueKey)) continue;
                    index = i;
                    break;
                }
                if (index < 0) continue;
                convert[index] = convertsMap.get(title);
            }
        }
        return JSONUtil.getJsonForList(fromList, convert, titles);
    }

    public static String getJsonForListAlias(List<?> fromList, String[] aliasTitles, Map<String, IConvertValue> convertsMap) {
        if (CollectionUtils.isEmpty(fromList)) {
            return "[]";
        }
        Object object = fromList.get(0);
        String[] titles = null;
        if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
            Map temp = (Map)object;
            titles = new String[temp.size()];
            int i = 0;
            for (Object keyObj : temp.keySet()) {
                titles[i++] = String.valueOf(keyObj);
            }
        } else {
            List<String> fields = ReflectAssist.findGetField(object.getClass());
            titles = fields.toArray(new String[fields.size()]);
        }
        if (aliasTitles != null && aliasTitles.length > 0) {
            titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles);
        }
        return JSONUtil.getJsonForList(fromList, convertsMap, titles);
    }

    public static String getJsonForListAlias(List<?> fromList) {
        return JSONUtil.getJsonForListAlias(fromList, null, null);
    }
}

