/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import net.wicp.tams.commons.LogHelp;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public abstract class IOUtil {
    private static final Logger logger = LogHelp.getLogger(IOUtil.class);

    public static String slurp(InputStream in) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fileToProperties(String filePath, Class classz) {
        Properties returnPro = new Properties();
        InputStream inputFile = null;
        try {
            inputFile = classz != null ? classz.getResourceAsStream(filePath) : Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
            returnPro.load(inputFile);
        }
        catch (FileNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u6587\u4ef6{}", (Object)filePath);
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6{}\u9519\u8bef", (Object)filePath);
        }
        finally {
            if (inputFile != null) {
                try {
                    inputFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return returnPro;
    }

    public static Properties fileToProperties(String filePath) {
        return IOUtil.fileToProperties(filePath, null);
    }

    public static String mergeFolderAndFilePath(String folderPath, String fileName) {
        if (StringUtils.isBlank((String)folderPath)) {
            return fileName;
        }
        if (StringUtils.isBlank((String)fileName)) {
            return folderPath;
        }
        if (!folderPath.endsWith(File.separator) && !folderPath.endsWith("/")) {
            return folderPath + File.separator + fileName;
        }
        return folderPath + fileName;
    }

    public static String getDirForFilePath(Class classStr, String filePath) {
        URL url = classStr.getResource(filePath);
        int lastIndex = url.getPath().lastIndexOf("/");
        if (lastIndex > 0) {
            return url.getPath().substring(0, lastIndex);
        }
        return null;
    }

    public static String getDirForCommonUtilFilePath(String filePath) {
        return IOUtil.getDirForFilePath(IOUtil.class, filePath);
    }

    public static long copyInToOut(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[1024];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }
}

