/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.wicp.tams.commons.Conf;
import net.wicp.tams.commons.LogHelp;
import net.wicp.tams.commons.exception.ExceptAll;
import net.wicp.tams.commons.exception.ProjectException;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;

public abstract class HttpClientUtil {
    private static final Logger logger = LogHelp.getLogger(HttpClientUtil.class);

    public static String sendGet(String url, String ecode) throws ProjectException {
        String result = null;
        HttpClientBuilder httpClient = HttpClientBuilder.create();
        HttpGet get = new HttpGet(url);
        InputStream in = null;
        try {
            CloseableHttpResponse response = httpClient.build().execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                int num;
                entity = new BufferedHttpEntity(entity);
                in = entity.getContent();
                byte[] read = new byte[1024];
                byte[] all = new byte[]{};
                while ((num = in.read(read)) > 0) {
                    byte[] temp = new byte[all.length + num];
                    System.arraycopy(all, 0, temp, 0, all.length);
                    System.arraycopy(read, 0, temp, all.length, num);
                    all = temp;
                }
                result = new String(all, ecode);
            }
        }
        catch (Exception e) {
            logger.error("\u5ba2\u6237\u7aef\u8fde\u63a5\u9519\u8bef\u3002");
            throw new ProjectException(ExceptAll.Project_default);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u9519\u8bef\u3002");
                    throw new ProjectException(ExceptAll.project_streamclose);
                }
            }
            get.abort();
        }
        return result;
    }

    public static String sendGet(String url) throws ProjectException {
        return HttpClientUtil.sendGet(url, Conf.get("common.encode"));
    }

    public static String sendGet(String url, Map<String, String> params) throws ProjectException {
        Set<String> keys = params.keySet();
        StringBuilder urlBuilder = new StringBuilder(url + "?");
        for (String key : keys) {
            urlBuilder.append(key).append("=").append(params.get(key)).append("&");
        }
        urlBuilder.delete(urlBuilder.length() - 1, urlBuilder.length());
        return HttpClientUtil.sendGet(urlBuilder.toString());
    }

    public static String sendPost(String url, Map<String, String> params) throws ProjectException {
        String result = null;
        HttpClientBuilder httpClient = HttpClientBuilder.create();
        HttpPost get = new HttpPost(url);
        ArrayList<BasicNameValuePair> qparams = new ArrayList<BasicNameValuePair>();
        Set<String> keys = params.keySet();
        for (String key : keys) {
            qparams.add(new BasicNameValuePair(key, params.get(key)));
        }
        try {
            get.setEntity((HttpEntity)new UrlEncodedFormEntity(qparams, Conf.get("common.encode")));
            CloseableHttpResponse response = httpClient.build().execute((HttpUriRequest)get);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                int num;
                entity = new BufferedHttpEntity(entity);
                InputStream in = entity.getContent();
                byte[] read = new byte[1024];
                byte[] all = new byte[]{};
                while ((num = in.read(read)) > 0) {
                    byte[] temp = new byte[all.length + num];
                    System.arraycopy(all, 0, temp, 0, all.length);
                    System.arraycopy(read, 0, temp, all.length, num);
                    all = temp;
                }
                result = new String(all, "UTF-8");
                if (null != in) {
                    in.close();
                }
            }
            get.abort();
            return result;
        }
        catch (Exception e) {
            throw new ProjectException(ExceptAll.Project_default);
        }
    }
}

