/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons.apiext;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.wicp.tams.commons.apiext.StringUtil;
import net.wicp.tams.commons.constant.DateFormatCase;
import net.wicp.tams.commons.constant.StrPattern;
import net.wicp.tams.commons.exception.ExceptAll;
import net.wicp.tams.commons.exception.IExcept;
import net.wicp.tams.commons.exception.ProjectException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.DateUtils;

public abstract class DateUtil {
    public static java.util.Date objToDate(Object ojbDate, DateFormat formate) {
        if (ojbDate == null) {
            return null;
        }
        java.util.Date date = null;
        if (ojbDate instanceof java.util.Date) {
            date = (java.util.Date)ojbDate;
        } else if (ojbDate instanceof Date) {
            Date tempObj = (Date)ojbDate;
            date = new java.util.Date(tempObj.getTime());
        } else if (ojbDate instanceof XMLGregorianCalendar) {
            date = DateUtil.xmlDateToDate((XMLGregorianCalendar)ojbDate);
        } else if (ojbDate instanceof String) {
            String strDate = String.valueOf(ojbDate);
            try {
                if (formate != null) {
                    date = formate.parse(strDate);
                } else {
                    if (StrPattern.date.checkStrFormat(strDate)) {
                        strDate = strDate + " 00:00:00";
                    }
                    if (StrPattern.date_time.checkStrFormat(String.valueOf(strDate)) && !"0001-01-01 00:00:00".equals(ojbDate) && !"1970-01-01 00:00:00".equals(ojbDate)) {
                        SimpleDateFormat format = null;
                        if (strDate.length() == 19) {
                            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            date = format.parse(strDate);
                        } else {
                            date = DateUtils.parseDate((String)strDate);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("String\u8f6c\u6362\u4e3aDate\u7c7b\u578b\u9519\u8bef");
            }
        }
        if (date == null) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff0c\u4e0d\u80fd\u8f6c\u4e3aDate\u7c7b\u578b");
        }
        return date;
    }

    public static String formatDate(Object bean, String path, String format, Boolean isTime) {
        if (StringUtils.isBlank((String)path)) {
            return "";
        }
        try {
            Object obj = PropertyUtils.getProperty((Object)bean, (String)path);
            java.util.Date curDate = DateUtil.objToDate(obj);
            if (curDate == null) {
                return "";
            }
            return DateUtil.formatDate(curDate, format, isTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String formatDate(java.util.Date oriDate, String format, Boolean isTime) {
        if (oriDate == null) {
            return "";
        }
        String formatStr = StringUtil.hasNull(format, isTime != null && isTime != false ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd");
        SimpleDateFormat curFormat = new SimpleDateFormat(formatStr);
        return curFormat.format(oriDate);
    }

    public static java.util.Date objToDate(Object ojbDate) {
        return DateUtil.objToDate(ojbDate, null);
    }

    public static java.util.Date setDayBeginTime(java.util.Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ca.getTime();
    }

    public static java.util.Date setDayAfterBeginTime(java.util.Date date, int num) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, num);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ca.getTime();
    }

    public static java.util.Date setDayAfterMonthTime(java.util.Date date, int monthNum) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(2, monthNum);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ca.getTime();
    }

    public static int differDays(java.util.Date beginData, java.util.Date endDate) {
        long resL = endDate.getTime() - beginData.getTime();
        long dayInt = resL / 1000L * 60L * 60L * 24L;
        return Integer.parseInt(Long.toString(dayInt));
    }

    public static int compareTo(java.util.Date beginData, int days, java.util.Date endDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(beginData);
        ca.add(5, days);
        Calendar otherCal = Calendar.getInstance();
        otherCal.setTime(endDate);
        return ca.compareTo(otherCal);
    }

    public static int compareMonthTo(java.util.Date beginData, int month, java.util.Date endDate) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(beginData);
        ca.add(2, month);
        Calendar otherCal = Calendar.getInstance();
        otherCal.setTime(endDate);
        return ca.compareTo(otherCal);
    }

    public static java.util.Date getLastDayOfMonth(java.util.Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(2, 1);
        ca.set(5, 1);
        ca.add(5, -1);
        ca.set(11, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        ca.set(14, 0);
        return ca.getTime();
    }

    public static java.util.Date getDateByTwoIso(String dateStr1, String dateStr2) throws ProjectException {
        try {
            int jIndex = dateStr1.indexOf("+");
            dateStr1 = dateStr1.substring(0, jIndex) + "GMT" + dateStr1.substring(jIndex);
            int j2Index = dateStr2.indexOf("+");
            dateStr2 = dateStr2.substring(0, j2Index) + "GMT" + dateStr2.substring(j2Index);
            Calendar returnDateTime = Calendar.getInstance();
            java.util.Date dateD = DateFormatCase.TyyyyMMddHHmmss.getInstanc().parse(dateStr1);
            java.util.Date dateT = DateFormatCase.TyyyyMMddHHmmss.getInstanc().parse(dateStr2);
            Calendar calDateT = Calendar.getInstance();
            returnDateTime.setTime(dateD);
            calDateT.setTime(dateT);
            returnDateTime.set(10, calDateT.get(10));
            returnDateTime.set(12, calDateT.get(12));
            returnDateTime.set(13, calDateT.get(13));
            return returnDateTime.getTime();
        }
        catch (ParseException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u89e3\u6790\u65f6\u95f4\u9519\u8bef");
        }
    }

    public static java.util.Date getDateByDojo(String dateStr1, String dateStr2) throws ProjectException {
        if (StringUtils.isBlank((String)dateStr1) || StringUtils.isBlank((String)dateStr2)) {
            throw new ProjectException(ExceptAll.param_error);
        }
        String tempDateStr = dateStr1 + dateStr2;
        try {
            java.util.Date dateT = DateFormatCase.TyyyyMMddHHmmssNoZ.getInstanc().parse(tempDateStr);
            return dateT;
        }
        catch (ParseException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u89e3\u6790\u65f6\u95f4\u9519\u8bef");
        }
    }

    public static java.util.Date xmlDateToDate(XMLGregorianCalendar xmlDate) {
        return xmlDate.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar dateToXmlDate(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        DatatypeFactory dtf = null;
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            // empty catch block
        }
        XMLGregorianCalendar dateType = dtf.newXMLGregorianCalendar();
        dateType.setYear(cal.get(1));
        dateType.setMonth(cal.get(2) + 1);
        dateType.setDay(cal.get(5));
        dateType.setHour(cal.get(11));
        dateType.setMinute(cal.get(12));
        dateType.setSecond(cal.get(13));
        return dateType;
    }

    public static java.util.Date getTomorrow(Object ojbDate) {
        java.util.Date ret = DateUtil.objToDate(ojbDate);
        ret = DateUtil.setDayAfterBeginTime(ret, 1);
        return ret;
    }

    public static String getTomorrowStr(Object ojbDate) {
        java.util.Date ori = DateUtil.getTomorrow(ojbDate);
        return DateFormatCase.YYYY_MM_DD.getInstanc().format(ori);
    }
}

