/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons;

import java.beans.Transient;
import java.io.Serializable;
import net.wicp.tams.commons.exception.ExceptAll;
import net.wicp.tams.commons.exception.IExcept;
import net.wicp.tams.commons.exception.ProjectException;
import net.wicp.tams.commons.exception.bean.ParamInfoBean;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.json.JSONObject;

public class Result
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean result;
    private String message;
    private IExcept except;
    private Object[] retObjs;
    private static Result suc = null;

    public Result(ProjectException opeExcept) {
        this.result = false;
        if (opeExcept == null) {
            throw new IllegalArgumentException();
        }
        this.except = opeExcept.getExcept();
    }

    public Result(IExcept except) {
        this.result = except == ExceptAll.no;
        this.except = except;
    }

    private Result(boolean result) {
        this.result = result;
    }

    private Result(String message) {
        this.result = false;
        this.except = ExceptAll.project_undefined;
        this.message = message;
    }

    public static Result getSuc() {
        if (suc == null) {
            suc = new Result(true);
            Result.suc.except = ExceptAll.no;
        }
        return suc;
    }

    public static Result getError(String errmsg) {
        return new Result(errmsg);
    }

    public IExcept getExcept() {
        return this.except;
    }

    public boolean isSuc() {
        return this.result;
    }

    @Transient
    public Object[] getRetObjs() {
        return this.retObjs;
    }

    public Object getRetObj(int index) {
        if (this.retObjs == null || this.retObjs.length <= index) {
            return null;
        }
        return this.retObjs[index];
    }

    public void setRetObjs(Object ... retObjs) {
        this.retObjs = retObjs;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage(ParamInfoBean errBean) {
        if (StringUtils.isNotBlank((String)this.message)) {
            return this.message;
        }
        return this.except.getErrMsg(errBean);
    }

    public String getMessage() {
        if (StringUtils.isNotBlank((String)this.message)) {
            return this.message;
        }
        return this.except.getErrMsg();
    }

    public JSONObject getJsonObj(ParamInfoBean errBean) {
        String message = this.getMessage(errBean);
        return new JSONObject(new Object[]{"result", this.result ? 1 : 0, "value", this.except.getErrorValue(), "code", this.except.getErrorCode(), "msg", message});
    }

    public JSONObject getJsonObj() {
        String message = this.getMessage();
        return new JSONObject(new Object[]{"result", this.result ? 1 : 0, "value", this.except.getErrorValue(), "code", this.except.getErrorCode(), "msg", message});
    }
}

