/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.wicp.tams.commons.apiext.CollectionUtil;
import net.wicp.tams.commons.apiext.IOUtil;
import net.wicp.tams.commons.apiext.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Conf {
    private static Logger logger = LoggerFactory.getLogger(Conf.class);
    private static final Properties utilProperties = IOUtil.fileToProperties("/commonsUtil.properties", Conf.class);
    private static long lastModified = 0L;
    private static final Map<String, Callback> reshBacks = new HashMap<String, Callback>();
    private static final Map<String, String[]> props = new HashMap<String, String[]>();
    private static Locale curLocale = new Locale(Conf.get("common.i18n"));

    public static void addCallBack(String moudle, Callback callback, String ... proNames) {
        Validate.isTrue((boolean)ArrayUtils.isNotEmpty((Object[])proNames));
        props.put(moudle, proNames);
        reshBacks.put(moudle, callback);
    }

    public static String get(String key) {
        return String.valueOf(utilProperties.get(key));
    }

    public static Map<String, String> getPre(String key) {
        return CollectionUtil.getPropsByKeypre(utilProperties, key);
    }

    public static void setCurLocale(Locale curLocale) {
        if (curLocale != null) {
            Conf.curLocale = curLocale;
        }
    }

    public static Properties copyProperties() {
        return (Properties)utilProperties.clone();
    }

    public static Locale getCurLocale() {
        return curLocale;
    }

    static {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileInputStream fileInputStream = null;
                try {
                    String url = Thread.currentThread().getContextClassLoader().getResource("/commonsUtil.properties").getPath();
                    File file = new File(url);
                    long curmodified = file.lastModified();
                    if (curmodified > lastModified) {
                        lastModified = curmodified;
                        Properties oldProperties = (Properties)utilProperties.clone();
                        Properties newProperties = new Properties();
                        fileInputStream = new FileInputStream(file);
                        newProperties.load(fileInputStream);
                        utilProperties.clear();
                        for (Object key : newProperties.keySet()) {
                            utilProperties.put(key, newProperties.get(key));
                        }
                        for (String moudle : reshBacks.keySet()) {
                            Object[] propNames = (String[])props.get(moudle);
                            if (ArrayUtils.isEmpty((Object[])propNames)) continue;
                            boolean ischange = false;
                            for (Object propName : propNames) {
                                if (((String)propName).endsWith("%s")) {
                                    String keyPre = ((String)propName).substring(0, ((String)propName).length() - 2);
                                    Map<String, String> oldmap = CollectionUtil.getPropsByKeypre(oldProperties, keyPre);
                                    Map<String, String> newmap = CollectionUtil.getPropsByKeypre(newProperties, keyPre);
                                    for (String key : oldmap.keySet()) {
                                        String oldValue = oldmap.get(key);
                                        String newValue = newmap.get(key);
                                        if (StringUtil.hasNull(oldValue).equals(StringUtil.hasNull(newValue))) continue;
                                        ischange = true;
                                        break;
                                    }
                                    if (!ischange) continue;
                                    break;
                                }
                                String oldValue = oldProperties.getProperty((String)propName);
                                String newValue = newProperties.getProperty((String)propName);
                                if (StringUtil.hasNull(oldValue).equals(StringUtil.hasNull(newValue))) continue;
                                ischange = true;
                                break;
                            }
                            if (!ischange) continue;
                            try {
                                ((Callback)reshBacks.get(moudle)).doReshConf(utilProperties);
                            }
                            catch (Exception e) {
                                logger.error("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u56de\u8c03\u6a21\u5757[" + moudle + "]\u9519\u8bef", (Throwable)e);
                            }
                        }
                        logger.info("\u6210\u529f\u5237\u65b0\u914d\u7f6e\u6587\u4ef6");
                    }
                }
                catch (Exception e) {
                    logger.error("classpath\u7684\u6839\u76ee\u5f55\u4e0b\u6ca1\u6709commonsUtil.properties\u6587\u4ef6\uff0c\u5c06\u4f7f\u7528commons.jar\u5305\u7684\u7f3a\u5c11\u914d\u7f6e\u3002", (Throwable)e);
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }, 0L, 60000L);
    }

    public static interface Callback {
        public void doReshConf(Properties var1);
    }
}

