/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.web;

import java.sql.Connection;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.Validate;

import lombok.Data;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.jdbc.MySqlAssit;
import net.wicp.tams.common.constant.dic.YesOrNo;

/***
 * 只支持一个字段的排序
 * 
 * @author 偏锋书生
 *
 *         2018年5月15日
 */
@Data
public class PageAssist {
	private final int pageSize;// 页面大小
	private final int pageNo;// 当前页号
	private long allNum;// 查询结果集(所有页)的总数
	private List<?> result;// 页面查询的结果
	private String sortField;// 排序字段
	private YesOrNo sortDesc = YesOrNo.yes;// 是否降序

	public PageAssist(int pageSize, int pageNo, int allNum) {
		Validate.isTrue(pageSize > 0, "页面大小必须大于0");
		Validate.isTrue(pageNo > 0, "页号必须大于0");
		int maxsize = Integer.parseInt(Conf.get("common.web.page.maxsize"));
		Validate.isTrue(pageNo < maxsize && pageSize * pageNo < maxsize, "查询的结果集不能超过" + maxsize + "，拒绝深度翻页");
		this.pageSize = pageSize;
		this.pageNo = pageNo;
		this.allNum = allNum;
	}

	public PageAssist(int pageSize, int pageNo) {
		this(pageSize, pageNo, -1);
	}

	public PageAssist(HttpServletRequest req) {
		this(new Integer(req.getParameter("rows")), new Integer(req.getParameter("page")));
	}

	public int getFrom() {
		return pageSize * (pageNo - 1);
	}

	public void queryDo(Connection conn, String sql, boolean isConvertKey) {
		List<Map<String, String>> querySqlMap = MySqlAssit.querySqlMap(conn, sql, getFrom(), pageSize, isConvertKey);
		this.result = querySqlMap;
		int querySqlCount = MySqlAssit.querySqlCount(conn, sql);
		this.allNum = querySqlCount;
	}

	public void queryDo(Connection conn, String sql) {
		queryDo(conn, sql, true);
	}
}
