/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import org.apache.commons.lang3.ArrayUtils;

public abstract class J2EEAssist {
    public static String buildUrlAbsolute(HttpServletRequest request, String protocol, String oriUrl) {
        String pro = StringUtil.hasNull((String[])new String[]{protocol, request.getProtocol().split("/")[0]});
        String pre = String.format("%s://%s:%s", pro, request.getServerName(), request.getLocalPort());
        return IOUtil.mergeFolderAndFilePath((String)pre, (String[])new String[]{oriUrl});
    }

    public static String buildWebsockertUrl(HttpServletRequest request, boolean isSsl, String oriUrl) {
        return J2EEAssist.buildUrlAbsolute(request, isSsl ? "wss" : "ws", oriUrl);
    }

    public static JSONObject packParams(HttpServletRequest request, boolean convert) {
        JSONObject retobj = new JSONObject();
        if (request == null) {
            return retobj;
        }
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String key = String.valueOf(parameterNames.nextElement());
            if (key.endsWith("[]")) {
                Object[] objs = request.getParameterValues(key);
                if (!ArrayUtils.isNotEmpty((Object[])objs)) continue;
                JSONArray ary = new JSONArray();
                for (int i = 0; i < objs.length; ++i) {
                    ary.add((Object)(convert ? JSONUtil.convertJsonValue((String)StringUtil.trimSpace((String)objs[i])) : StringUtil.trimSpace((String)objs[i])));
                }
                retobj.put(key.replace("[]", ""), (Object)ary);
                continue;
            }
            String str = ArrayUtils.isNotEmpty((Object[])request.getParameterValues(key)) ? CollectionUtil.arrayJoin((Object[])request.getParameterValues(key), (String)",") : request.getParameter(key);
            retobj.put(key, (Object)(convert ? JSONUtil.convertJsonValue((String)StringUtil.trimSpace((String)str)) : StringUtil.trimSpace((String)request.getParameter(key))));
        }
        return retobj;
    }

    public static String getRequestPayload(HttpServletRequest req) {
        try {
            int len;
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = req.getReader();
            char[] buff = new char[1024];
            while ((len = reader.read(buff)) != -1) {
                sb.append(buff, 0, len);
            }
            return URLDecoder.decode(sb.toString(), "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static OutputStream getExcelOS(HttpServletResponse response, String fileName, boolean isclear) {
        try {
            ServletOutputStream os = response.getOutputStream();
            if (isclear) {
                response.reset();
            }
            response.setHeader("Content-disposition", "attachment; filename=" + fileName + ".xls");
            response.setContentType("application/msexcel");
            return os;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static OutputStream getFileOS(HttpServletResponse response, String fileFullName, boolean isclear) {
        try {
            ServletOutputStream os = response.getOutputStream();
            if (isclear) {
                response.reset();
            }
            response.setHeader("Content-disposition", "attachment; filename=" + fileFullName);
            response.setContentType("application/octet-stream");
            return os;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void returnJsonResponse(HttpServletResponse response, String jsonMsg) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        try {
            PrintWriter out = response.getWriter();
            out.print(jsonMsg);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resWithJson(HttpServletResponse response, Result ret) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.append(ret.retJsonObj().toString());
        }
    }

    public static String getWebService(HttpServletRequest request, String relaUrl) {
        String returl = Conf.get((String)"common.web.websocket.context");
        if (StringUtil.isNull((Object)returl)) {
            String context = Conf.get((String)"common.apiext.context");
            returl = context.replace(request.getScheme(), "ws");
        }
        return IOUtil.mergeFolderAndFilePath((String)returl, (String[])new String[]{relaUrl});
    }

    public static void returnJsonResponse(HttpServletResponse response, Result optResult) {
        J2EEAssist.returnJsonResponse(response, optResult.retJsonObj().toJSONString());
    }
}

