/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.web;

import java.util.List;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.constant.dic.YesOrNo;
import org.apache.commons.lang3.Validate;

public class PageAssist {
    private final int pageSize;
    private final int pageNo;
    private long allNum;
    private List<?> result;
    private String sortField;
    private YesOrNo sortDesc = YesOrNo.yes;

    public PageAssist(int pageSize, int pageNo, int allNum) {
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.isTrue((pageNo > 0 ? 1 : 0) != 0, (String)"\u9875\u53f7\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        int maxsize = Integer.parseInt(Conf.get((String)"common.web.page.maxsize"));
        Validate.isTrue((pageNo < maxsize && pageSize * pageNo < maxsize ? 1 : 0) != 0, (String)("\u67e5\u8be2\u7684\u7ed3\u679c\u96c6\u4e0d\u80fd\u8d85\u8fc7" + maxsize + "\uff0c\u62d2\u7edd\u6df1\u5ea6\u7ffb\u9875"), (Object[])new Object[0]);
        this.pageSize = pageSize;
        this.pageNo = pageNo;
        this.allNum = allNum;
    }

    public PageAssist(int pageSize, int pageNo) {
        this(pageSize, pageNo, -1);
    }

    public int getFrom() {
        return this.pageSize * (this.pageNo - 1);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public long getAllNum() {
        return this.allNum;
    }

    public List<?> getResult() {
        return this.result;
    }

    public String getSortField() {
        return this.sortField;
    }

    public YesOrNo getSortDesc() {
        return this.sortDesc;
    }

    public void setAllNum(long allNum) {
        this.allNum = allNum;
    }

    public void setResult(List<?> result) {
        this.result = result;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public void setSortDesc(YesOrNo sortDesc) {
        this.sortDesc = sortDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageAssist)) {
            return false;
        }
        PageAssist other = (PageAssist)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        if (this.getAllNum() != other.getAllNum()) {
            return false;
        }
        List<?> this$result = this.getResult();
        List<?> other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        String this$sortField = this.getSortField();
        String other$sortField = other.getSortField();
        if (this$sortField == null ? other$sortField != null : !this$sortField.equals(other$sortField)) {
            return false;
        }
        YesOrNo this$sortDesc = this.getSortDesc();
        YesOrNo other$sortDesc = other.getSortDesc();
        return !(this$sortDesc == null ? other$sortDesc != null : !this$sortDesc.equals(other$sortDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageAssist;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getPageNo();
        long $allNum = this.getAllNum();
        result = result * 59 + (int)($allNum >>> 32 ^ $allNum);
        List<?> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        String $sortField = this.getSortField();
        result = result * 59 + ($sortField == null ? 43 : $sortField.hashCode());
        YesOrNo $sortDesc = this.getSortDesc();
        result = result * 59 + ($sortDesc == null ? 43 : $sortDesc.hashCode());
        return result;
    }

    public String toString() {
        return "PageAssist(pageSize=" + this.getPageSize() + ", pageNo=" + this.getPageNo() + ", allNum=" + this.getAllNum() + ", result=" + this.getResult() + ", sortField=" + this.getSortField() + ", sortDesc=" + this.getSortDesc() + ")";
    }
}

