/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer.instrumentation;

import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.tracer.instrumentation.IClassEnhance;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsHandler
implements IClassEnhance {
    private static final Logger log = LoggerFactory.getLogger(AbsHandler.class);
    public static final ClassPool pool = ClassPool.getDefault();
    protected final String className;

    public AbsHandler(String className) {
        this.className = className;
    }

    public abstract Result enhance(CtMethod var1, String var2);

    public abstract List<CtMethod> findEnhanceMethods(CtClass var1);

    public abstract Result checkClass(CtClass var1);

    @Override
    public CtClass transformed() {
        pool.importPackage("net.wicp.tams.common");
        pool.importPackage("net.wicp.tams.common.tracer");
        pool.importPackage("net.wicp.tams.common.tracer.agent");
        CtClass cc = null;
        try {
            cc = pool.getCtClass(this.className);
        }
        catch (NotFoundException e) {
            log.error("\u6ca1\u6709\u627e\u5230\u7c7b[{}]", (Object)this.className);
            return null;
        }
        Result checkResult = this.checkClass(cc);
        if (!checkResult.isSuc()) {
            log.error("\u7c7b[{}]\u68c0\u67e5\u4e0d\u901a\u8fc7", (Object)this.className);
            return null;
        }
        List<CtMethod> allmethods = this.findEnhanceMethods(cc);
        if (CollectionUtils.isEmpty(allmethods)) {
            log.error("\u7c7b[{}]\u6ca1\u6709\u8981\u52a0\u5f3a\u7684\u65b9\u6cd5", (Object)this.className);
            return null;
        }
        for (CtMethod ctMethod : allmethods) {
            try {
                CtMethod copiedMethod = CtNewMethod.copy((CtMethod)ctMethod, (String)cc.makeUniqueName(ctMethod.getName()), (CtClass)cc, null);
                copiedMethod.setModifiers(2);
                cc.addMethod(copiedMethod);
                Result ret = this.enhance(ctMethod, copiedMethod.getName());
                if (ret.isSuc()) continue;
                log.error("\u7c7b[{}]\u7684[{}]\u65b9\u6cd5\u52a0\u5f3a\u4e0d\u6210\u529f", (Object)this.className, (Object)ctMethod.getName());
                return null;
            }
            catch (Exception e) {
                log.error(String.format("\u7c7b[%s]\u7684[%s]\u65b9\u6cd5\u52a0\u5f3a\u65f6\u5f02\u5e38", this.className, ctMethod.getName()), (Throwable)e);
                return null;
            }
        }
        log.info("\u7c7b[{}]\u5df2\u52a0\u5f3a[{}]\u4e2a\u65b9\u6cd5", (Object)this.className, (Object)allmethods.size());
        return cc;
    }
}

