/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer;

import com.google.common.base.Optional;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.wicp.tams.common.tracer.AnnotationData;
import net.wicp.tams.common.tracer.Annotations;
import net.wicp.tams.common.tracer.SpanContext;
import net.wicp.tams.common.tracer.SpanData;
import net.wicp.tams.common.tracer.SpanHelper;
import net.wicp.tams.common.tracer.TraceLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Span
implements AutoCloseable,
SpanData {
    private static final Logger log = LoggerFactory.getLogger(Span.class);
    private final BigInteger traceId;
    private final Optional<BigInteger> parentSpanId;
    private final BigInteger spanId;
    private final String name;
    private final String host;
    private final Integer pid;
    private final TraceLevel traceLevel;
    private final long startTime;
    protected final List<AnnotationData> annotations;
    private final UUID guid = UUID.randomUUID();
    private long duration;

    protected Span(Optional<BigInteger> parentSpanId, BigInteger spanId, String name, BigInteger traceId, long startTime, long startNanos, TraceLevel traceLevel) {
        this.host = Annotations.getServiceAnnotations().getHost();
        this.pid = Annotations.getServiceAnnotations().getPid();
        this.parentSpanId = parentSpanId;
        this.spanId = spanId;
        this.name = name;
        this.traceId = traceId;
        this.startTime = startTime;
        this.duration = startNanos;
        this.traceLevel = traceLevel;
        this.annotations = new LinkedList<AnnotationData>();
    }

    public abstract void addAnnotation(String var1);

    public abstract void addAnnotation(String var1, String var2);

    protected abstract void afterClose();

    public final void end() {
        this.duration = System.nanoTime() - this.duration;
        Optional<SpanContext> context = SpanHelper.currentContext();
        if (!context.isPresent()) {
            throw new IllegalStateException("Span.end() from a detached span.");
        }
        ((SpanContext)context.get()).endSpan(this);
        this.afterClose();
    }

    @Override
    public final void close() {
        this.end();
    }

    @Override
    public final BigInteger getTraceId() {
        return this.traceId;
    }

    @Override
    public final BigInteger getSpanId() {
        return this.spanId;
    }

    @Override
    public final Optional<BigInteger> getParentSpanId() {
        return this.parentSpanId;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final String getHost() {
        return this.host;
    }

    public final Integer getPid() {
        return this.pid;
    }

    @Override
    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public final long getDuration() {
        return this.duration;
    }

    @Override
    public final List<AnnotationData> getAnnotations() {
        return this.annotations;
    }

    final TraceLevel getTraceLevel() {
        return this.traceLevel;
    }

    public String toString() {
        return "Span{traceId=" + this.traceId + ", parentSpanId=" + this.parentSpanId + ", spanId=" + this.spanId + ", name='" + this.name + '\'' + ", startTime=" + this.startTime + ", duration=" + this.duration + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Span span = (Span)o;
        return this.guid.equals(span.guid);
    }

    public int hashCode() {
        return this.guid.hashCode();
    }
}

