/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer;

import com.google.common.base.Optional;
import java.math.BigInteger;
import net.wicp.tams.common.tracer.Annotation;
import net.wicp.tams.common.tracer.Span;
import net.wicp.tams.common.tracer.SpanHelper;
import net.wicp.tams.common.tracer.SpanSink;
import net.wicp.tams.common.tracer.SpanSinkRegistry;
import net.wicp.tams.common.tracer.TraceLevel;

public class EnabledSpan
extends Span {
    EnabledSpan(BigInteger traceId, BigInteger spanId, Optional<BigInteger> parentSpanId, String name, TraceLevel traceLevel) {
        super(parentSpanId, spanId, name, traceId, SpanHelper.nowInNanoseconds(), System.nanoTime(), traceLevel);
    }

    @Override
    public void addAnnotation(String name) {
        this.annotations.add(new Annotation(SpanHelper.nowInNanoseconds(), name));
    }

    @Override
    public void addAnnotation(String name, String message) {
        this.annotations.add(new Annotation(SpanHelper.nowInNanoseconds(), name, message));
    }

    @Override
    protected void afterClose() {
        Iterable<SpanSink> sinks = SpanSinkRegistry.getSpanSinks();
        if (this.getTraceLevel() == TraceLevel.ON) {
            for (SpanSink sink : sinks) {
                sink.record(this);
            }
        }
    }
}

