/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer.agent.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.wicp.tams.common.tracer.Span;
import net.wicp.tams.common.tracer.SpanHelper;
import net.wicp.tams.common.tracer.agent.jdbc.InstrumentedConnection;

public class InstrumentedStatement
implements Statement {
    private final InstrumentedConnection connection;
    private final Statement underlying;
    private final String sql;

    public InstrumentedStatement(InstrumentedConnection connection, Statement underlying, String sql) {
        this.connection = connection;
        this.underlying = underlying;
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute Query: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            ResultSet set = this.underlying.executeQuery(sql);
            span.addAnnotation("ClientReceived");
            ResultSet resultSet = set;
            return resultSet;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute Update: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            int rows = this.underlying.executeUpdate(sql);
            span.addAnnotation("ClientReceived");
            int n = rows;
            return n;
        }
    }

    @Override
    public void close() throws SQLException {
        this.underlying.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.underlying.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.underlying.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.underlying.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.underlying.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.underlying.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.underlying.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.underlying.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.underlying.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.underlying.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.underlying.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.underlying.setCursorName(name);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            boolean result = this.underlying.execute(sql);
            span.addAnnotation("ClientReceived");
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.underlying.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.underlying.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.underlying.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.underlying.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.underlying.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.underlying.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.underlying.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.underlying.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.underlying.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.underlying.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.underlying.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute Batch");){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            int[] updateCounts = this.underlying.executeBatch();
            span.addAnnotation("ClientReceived");
            int[] nArray = updateCounts;
            return nArray;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.underlying.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.underlying.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute Update: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            int count = this.underlying.executeUpdate(sql, autoGeneratedKeys);
            span.addAnnotation("ClientReceived");
            int n = count;
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute Update: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            int count = this.underlying.executeUpdate(sql, columnIndexes);
            span.addAnnotation("ClientReceived");
            int n = count;
            return n;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute Update: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            int count = this.underlying.executeUpdate(sql, columnNames);
            span.addAnnotation("ClientReceived");
            int n = count;
            return n;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            boolean result = this.underlying.execute(sql, autoGeneratedKeys);
            span.addAnnotation("ClientReceived");
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            boolean result = this.underlying.execute(sql, columnIndexes);
            span.addAnnotation("ClientReceived");
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try (Span span = SpanHelper.startSpan("Execute: " + sql);){
            span.addAnnotation("ServiceName", this.connection.getUrl());
            span.addAnnotation("ClientSent");
            boolean result = this.underlying.execute(sql, columnNames);
            span.addAnnotation("ClientReceived");
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.underlying.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.underlying.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.underlying.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.underlying.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.underlying.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.underlying.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.underlying.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.underlying.isWrapperFor(iface);
    }
}

