/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.logging.Logger;
import net.wicp.tams.common.tracer.DisabledSpan;
import net.wicp.tams.common.tracer.EnabledSpan;
import net.wicp.tams.common.tracer.IDGenerator;
import net.wicp.tams.common.tracer.Sampling;
import net.wicp.tams.common.tracer.Span;
import net.wicp.tams.common.tracer.SpanContext;
import net.wicp.tams.common.tracer.TraceLevel;

public class SpanHelper {
    private static final ThreadLocal<SpanContext> spanContext = new ThreadLocal();
    static final Logger LOG = Logger.getLogger(SpanHelper.class.getName());
    static Sampling sampler = Sampling.ON;
    private static final IDGenerator idGenerator = new IDGenerator();

    public static Sampling getSampler() {
        return sampler;
    }

    public static void setSampler(Sampling sampler) {
        SpanHelper.sampler = sampler;
    }

    public static Span startTrace(String name) {
        return SpanHelper.start(name, (Optional<BigInteger>)Optional.absent(), (Optional<BigInteger>)Optional.absent(), (Optional<BigInteger>)Optional.absent(), sampler.trace() ? TraceLevel.ON : TraceLevel.OFF);
    }

    public static Span startSpan(String name) {
        return SpanHelper.start(name, (Optional<BigInteger>)Optional.absent(), (Optional<BigInteger>)Optional.absent(), (Optional<BigInteger>)Optional.absent(), TraceLevel.INHERIT);
    }

    public static Span attachSpan(BigInteger traceId, BigInteger spanId, String name) {
        return SpanHelper.start(name, (Optional<BigInteger>)Optional.of((Object)traceId), (Optional<BigInteger>)Optional.of((Object)spanId), (Optional<BigInteger>)Optional.absent(), TraceLevel.ON);
    }

    public static Span startSpan(BigInteger traceId, BigInteger parentSpanId, String name) {
        return SpanHelper.start(name, (Optional<BigInteger>)Optional.of((Object)traceId), (Optional<BigInteger>)Optional.absent(), (Optional<BigInteger>)Optional.of((Object)parentSpanId), TraceLevel.ON);
    }

    public static Optional<Span> currentSpan() {
        SpanContext context = spanContext.get();
        if (context == null) {
            return Optional.absent();
        }
        return context.currentSpan();
    }

    private static Span start(String name, Optional<BigInteger> traceId, Optional<BigInteger> spanId, Optional<BigInteger> parentSpanId, TraceLevel traceLevel) {
        SpanContext context = spanContext.get();
        if (context == null) {
            context = new SpanContext();
            spanContext.set(context);
        }
        if (traceLevel == TraceLevel.INHERIT) {
            traceLevel = context.currentTraceLevel();
        }
        if (!traceId.isPresent() && !(traceId = context.currentTraceId()).isPresent()) {
            traceId = Optional.of((Object)idGenerator.generateTraceId());
        }
        if (!parentSpanId.isPresent()) {
            parentSpanId = context.currentSpanId();
        }
        if (!spanId.isPresent()) {
            spanId = Optional.of((Object)idGenerator.generateSpanId());
        }
        Span span = traceLevel == TraceLevel.OFF ? new DisabledSpan() : new EnabledSpan((BigInteger)traceId.get(), (BigInteger)spanId.get(), parentSpanId, name, traceLevel);
        context.startSpan(span);
        return span;
    }

    static long nowInNanoseconds() {
        return System.currentTimeMillis() * 1000000L;
    }

    static Optional<SpanContext> currentContext() {
        return Optional.fromNullable((Object)spanContext.get());
    }

    static ImmutableList<Span> captureSpans() {
        SpanContext context = spanContext.get();
        if (context != null) {
            return context.captureSpans();
        }
        return ImmutableList.of();
    }
}

