/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.tracer.SpanData;
import net.wicp.tams.common.tracer.SpanSink;

public class AsynchronousSpanSink
implements SpanSink {
    private final ExecutorService executor;
    private final JobFactory jobFactory;

    public AsynchronousSpanSink(JobFactory jobFactory) {
        this(Executors.newSingleThreadExecutor(), jobFactory);
    }

    public AsynchronousSpanSink(ExecutorService executor, JobFactory jobFactory) {
        this.executor = executor;
        this.jobFactory = jobFactory;
    }

    @Override
    public void record(SpanData spanData) {
        Runnable job = this.jobFactory.createJob(spanData);
        this.executor.execute(job);
    }

    public int shutdown(long timeout, TimeUnit timeunit) {
        try {
            this.executor.shutdown();
            if (this.executor.awaitTermination(timeout, timeunit)) {
                return 0;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.executor.shutdownNow().size();
    }

    public static interface JobFactory {
        public Runnable createJob(SpanData var1);
    }
}

