/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer.instrumentation.impl;

import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import net.wicp.tams.common.tracer.instrumentation.impl.EnhanceSuperClass;
import net.wicp.tams.commons.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhanceHttpServlet
extends EnhanceSuperClass {
    private static final Logger log = LoggerFactory.getLogger(EnhanceHttpServlet.class);

    public EnhanceHttpServlet(String className) {
        super(className, "javax.servlet.http.HttpServlet");
    }

    @Override
    public Result enhance(CtMethod methods, String newMethodName) {
        try {
            String source = Resources.toString((URL)Resources.getResource(this.getClass(), (String)"/enhance/HttpServlet_service.javassist"), (Charset)Charset.forName("utf-8"));
            pool.importPackage("java.util");
            pool.importPackage("java.math");
            pool.importPackage("org.slf4j.MDC");
            methods.setBody(source, "this", newMethodName);
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return Result.getError((String)"\u589e\u5f3a\u65b9\u6cd5\u65f6\u9519\u8bef");
        }
    }

    @Override
    public List<CtMethod> findEnhanceMethods(CtClass cc) {
        try {
            CtClass request = pool.get("javax.servlet.http.HttpServletRequest");
            CtClass response = pool.get("javax.servlet.http.HttpServletResponse");
            try {
                CtMethod serviceMethod = cc.getDeclaredMethod("service", new CtClass[]{request, response});
                ArrayList<CtMethod> ret = new ArrayList<CtMethod>();
                ret.add(serviceMethod);
                return ret;
            }
            catch (NotFoundException e) {
                log.error("", (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return null;
    }
}

