/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.management.ManagementFactory;

public class ServiceAnnotations {
    public String service;
    public int pid;
    public String host;

    public ServiceAnnotations() {
        this.initPidAndHost();
    }

    public ServiceAnnotations(String service) {
        this.service = service;
        this.initPidAndHost();
    }

    private void initPidAndHost() {
        String pidAndHostString = ManagementFactory.getRuntimeMXBean().getName();
        if (pidAndHostString != null) {
            String[] pidAndHost = pidAndHostString.split("@");
            if (pidAndHost.length == 2) {
                try {
                    this.pid = Integer.parseInt(pidAndHost[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.host = pidAndHost[1];
            } else {
                this.host = pidAndHostString;
            }
        }
    }

    public String getService() {
        return this.service;
    }

    @JsonIgnore
    public int getPid() {
        return this.pid;
    }

    @JsonIgnore
    public String getHost() {
        return this.host;
    }
}

