/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer.instrumentation.impl;

import java.util.ArrayList;
import java.util.List;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import net.wicp.tams.common.tracer.instrumentation.impl.EnhanceSuperClass;
import net.wicp.tams.commons.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnhanceJdbcDriver
extends EnhanceSuperClass {
    private static final Logger log = LoggerFactory.getLogger(EnhanceJdbcDriver.class);

    public EnhanceJdbcDriver(String className) {
        super(className, "java.sql.Driver");
    }

    @Override
    public Result enhance(CtMethod method, String newMethodName) {
        try {
            pool.importPackage("net.wicp.tams.commons.tracer.agent.jdbc");
            method.setBody("{ return new InstrumentedConnection($1, $proceed($$)); }", "this", newMethodName);
        }
        catch (Exception e) {
            return Result.getError((String)("\u52a0\u5f3a\u9519\u8bef\uff1a" + e.getMessage()));
        }
        return Result.getSuc();
    }

    @Override
    public List<CtMethod> findEnhanceMethods(CtClass cc) {
        ArrayList<CtMethod> retlist = new ArrayList<CtMethod>();
        try {
            CtMethod connect = cc.getDeclaredMethod("connect", new CtClass[]{pool.get("java.lang.String"), pool.get("java.util.Properties")});
            if (!Modifier.isAbstract((int)connect.getModifiers())) {
                retlist.add(connect);
            }
        }
        catch (NotFoundException e) {
            log.error("\u65b9\u6cd5[connect]\u6ca1\u6709\u627e\u5230", (Throwable)e);
        }
        return retlist;
    }
}

