/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer;

import com.google.common.base.Optional;
import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.wicp.tams.common.tracer.AnnotationData;
import net.wicp.tams.common.tracer.SpanData;

public class Trace {
    private final BigInteger traceId;
    private final ConcurrentMap<BigInteger, List<SpanData>> childSpans;
    private final ConcurrentMap<BigInteger, List<AnnotationData>> annotations;
    private SpanData root = null;

    public Trace(BigInteger traceId) {
        this.traceId = traceId;
        this.childSpans = new ConcurrentHashMap<BigInteger, List<SpanData>>();
        this.annotations = new ConcurrentHashMap<BigInteger, List<AnnotationData>>();
    }

    public BigInteger getTraceId() {
        return this.traceId;
    }

    public SpanData getRoot() {
        return this.root;
    }

    public List<SpanData> getChildren(BigInteger spanId) {
        if (spanId == null) {
            return Collections.emptyList();
        }
        return (List)Optional.fromNullable(this.childSpans.get(spanId)).or(Collections.emptyList());
    }

    public List<AnnotationData> getAnnotations(BigInteger spanId) {
        if (spanId == null) {
            return Collections.emptyList();
        }
        return (List)Optional.fromNullable(this.annotations.get(spanId)).or(Collections.emptyList());
    }

    public void addSpan(SpanData spanData) {
        Optional<BigInteger> parentSpanId = spanData.getParentSpanId();
        if (!parentSpanId.isPresent()) {
            this.root = spanData;
        } else {
            LinkedList<SpanData> newSiblings = new LinkedList<SpanData>();
            newSiblings.add(spanData);
            List siblings = this.childSpans.putIfAbsent((BigInteger)parentSpanId.get(), newSiblings);
            if (siblings != null) {
                siblings.add(spanData);
            }
        }
        for (AnnotationData annotation : spanData.getAnnotations()) {
            this.addAnnotation(spanData.getSpanId(), annotation);
        }
    }

    public void addAnnotation(BigInteger spanId, AnnotationData data) {
        LinkedList<AnnotationData> currentAnnotation = new LinkedList<AnnotationData>();
        currentAnnotation.add(data);
        List previousAnnotations = this.annotations.putIfAbsent(spanId, currentAnnotation);
        if (previousAnnotations != null) {
            previousAnnotations.add(data);
        }
    }
}

