/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer;

import java.math.BigInteger;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.wicp.tams.common.tracer.DisabledSpan;
import net.wicp.tams.common.tracer.SpanData;
import net.wicp.tams.common.tracer.SpanSink;
import net.wicp.tams.common.tracer.Trace;

public class InMemorySpanSinkSource
implements SpanSink {
    private final ConcurrentMap<BigInteger, Trace> traces = new ConcurrentHashMap<BigInteger, Trace>();

    public Collection<Trace> getTraces() {
        return this.traces.values();
    }

    public Trace getTrace(BigInteger traceId) {
        return traceId == null ? null : (Trace)this.traces.get(traceId);
    }

    @Override
    public void record(SpanData spanData) {
        if (spanData instanceof DisabledSpan) {
            throw new IllegalArgumentException("Should never be recording disabled spans");
        }
        Trace newTrace = new Trace(spanData.getTraceId());
        newTrace.addSpan(spanData);
        Trace trace = this.traces.putIfAbsent(spanData.getTraceId(), newTrace);
        if (trace != null) {
            trace.addSpan(spanData);
        }
    }

    public int recordedTraceCount() {
        return this.traces.size();
    }
}

