package net.wicp.tams.common.tracer.instrumentation.impl;

import javassist.CtClass;
import javassist.NotFoundException;
import net.wicp.tams.commons.Result;
import net.wicp.tams.common.tracer.instrumentation.AbsHandler;

public abstract class EnhanceSuperClass extends AbsHandler {

	protected final String superCalssName;

	public EnhanceSuperClass(String className, String superCalssName) {
		super(className);
		this.superCalssName = superCalssName;
	}

	@Override
	public Result checkClass(CtClass cc) {
		try {
			boolean isSub = cc.subtypeOf(pool.get(superCalssName));
			if (isSub) {
				return Result.getSuc();
			} else {
				return Result.getError(String.format("不是[%s]的子类，不能进行加强", superCalssName));
			}
		} catch (NotFoundException e) {
			return Result.getError(String.format("检查[%s]类异常。", className));
		}
	}

}
