/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer.logging;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import net.wicp.tams.common.tracer.AsynchronousSpanSink;
import net.wicp.tams.common.tracer.SpanData;

public class LogJobFactory
implements AsynchronousSpanSink.JobFactory {
    private static final Logger LOG = Logger.getLogger(LogJob.class.getName());
    private final WriterProvider writerProvider;
    private ObjectMapper objectMapper;

    private LogJobFactory(WriterProvider writerProvider) {
        this.writerProvider = writerProvider;
        this.objectMapper = new ObjectMapper().setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.LowerCaseWithUnderscoresStrategy()).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new GuavaModule());
    }

    public static LogJobFactory withWriter(final Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Writer must not be null");
        }
        return LogJobFactory.withWriterProvider(new WriterProvider(){

            @Override
            public Writer getWriter() throws IOException {
                return writer;
            }
        });
    }

    public static LogJobFactory withFile(final String file) throws IOException {
        try (FileOutputStream ignored = new FileOutputStream(file, true);){
            LogJobFactory logJobFactory = LogJobFactory.withWriterProvider(new WriterProvider(){

                @Override
                public Writer getWriter() throws IOException {
                    return new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), Charset.forName("UTF-8").newEncoder());
                }
            });
            return logJobFactory;
        }
    }

    @Override
    public Runnable createJob(SpanData data) {
        return new LogJob(data);
    }

    private static LogJobFactory withWriterProvider(WriterProvider writerProvider) {
        return new LogJobFactory(writerProvider);
    }

    private static interface WriterProvider {
        public Writer getWriter() throws IOException;
    }

    private class LogJob
    implements Runnable {
        private final Object object;

        public LogJob(Object object) {
            this.object = object;
        }

        @Override
        public void run() {
            try (PrintWriter writer = new PrintWriter(LogJobFactory.this.writerProvider.getWriter());){
                writer.println(LogJobFactory.this.objectMapper.writeValueAsString(this.object));
                writer.flush();
            }
            catch (IOException e) {
                LOG.throwing(LogJob.class.getName(), "run", e);
            }
        }
    }
}

