/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.tracer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Stack;
import net.wicp.tams.common.tracer.DisabledSpan;
import net.wicp.tams.common.tracer.Sampling;
import net.wicp.tams.common.tracer.Span;
import net.wicp.tams.common.tracer.SpanHelper;
import net.wicp.tams.common.tracer.TraceLevel;

class SpanContext {
    private final Stack<Span> spans = new Stack();

    SpanContext() {
    }

    ImmutableList<Span> captureSpans() {
        return ImmutableList.copyOf(this.spans);
    }

    public Optional<Span> currentSpan() {
        if (this.spans.isEmpty()) {
            return Optional.absent();
        }
        Span span = this.spans.peek();
        return Optional.of((Object)span);
    }

    public Optional<BigInteger> currentTraceId() {
        Optional<Span> currentSpan = this.currentSpan();
        if (!currentSpan.isPresent()) {
            return Optional.absent();
        }
        if (currentSpan.get() instanceof DisabledSpan) {
            return Optional.absent();
        }
        return currentSpan.transform((Function)new Function<Span, BigInteger>(){

            public BigInteger apply(Span input) {
                return input.getTraceId();
            }
        });
    }

    public Optional<BigInteger> currentSpanId() {
        Optional<Span> currentSpan = this.currentSpan();
        if (!currentSpan.isPresent()) {
            return Optional.absent();
        }
        if (currentSpan.get() instanceof DisabledSpan) {
            return Optional.absent();
        }
        return this.currentSpan().transform((Function)new Function<Span, BigInteger>(){

            public BigInteger apply(Span input) {
                return input.getSpanId();
            }
        });
    }

    public void startSpan(Span span) {
        this.spans.push(span);
    }

    public void endSpan(Span span) {
        if (this.spans.isEmpty()) {
            SpanHelper.LOG.warning("Ending span " + span.getName() + ":" + span.getSpanId() + " when no spans exist in SpanContext");
        }
        Span poppedSpan = this.spans.pop();
        int extraPops = 0;
        while (!Objects.equals(poppedSpan, span)) {
            ++extraPops;
            poppedSpan = this.spans.pop();
        }
        if (extraPops > 0) {
            SpanHelper.LOG.warning("Popped " + extraPops + " unclosed Spans");
        }
    }

    public TraceLevel currentTraceLevel() {
        if (this.spans.isEmpty()) {
            if (SpanHelper.sampler == Sampling.ON) {
                return TraceLevel.ON;
            }
            return TraceLevel.OFF;
        }
        return this.spans.peek().getTraceLevel();
    }
}

