/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring.connector.quartz;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.spring.quartz.JobTaskService;
import net.wicp.tams.common.spring.quartz.bean.ScheduleJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service(value="quartz.add")
@ConditionalOnProperty(name={"common.spring.quartz.enable"}, havingValue="true")
public class QuartzAdd
implements IBusiApp {
    private static final Logger log = LoggerFactory.getLogger(QuartzAdd.class);
    @Autowired
    private JobTaskService jobTaskService;

    public CusDynaBean exe(CusDynaBean inputBean, CusDynaBean outBeanOri) throws ProjectException {
        String jobName = inputBean.getStrValueByName("jobName");
        String jobGroup = inputBean.getStrValueByName("jobGroup");
        String cronExpression = inputBean.getStrValueByName("cronExpression");
        String springName = inputBean.getStrValueByName("springName");
        String beanClass = inputBean.getStrValueByName("beanClass");
        String description = inputBean.getStrValueByName("description");
        YesOrNo isActiv = (YesOrNo)inputBean.getByType(YesOrNo.class, "isActiv");
        YesOrNo isConcurrent = (YesOrNo)inputBean.getByType(YesOrNo.class, "isConcurrent");
        if (StringUtil.isNull((Object)springName) && StringUtil.isNull((Object)beanClass)) {
            log.error("springName\u4e0ebeanClass\u4e8c\u8005\u5fc5\u987b\u586b\u4e00\u4e2a");
            outBeanOri.setResult(Result.getError((String)"springName\u4e0ebeanClass\u4e8c\u8005\u5fc5\u987b\u586b\u4e00\u4e2a"));
            return outBeanOri;
        }
        ScheduleJob scheduleJob = this.jobTaskService.getTaskByGroupAndName(jobGroup, jobName);
        if (scheduleJob != null) {
            outBeanOri.setResult(Result.getError((String)"\u4efb\u52a1\u5df2\u5b58\u5728"));
            return outBeanOri;
        }
        ScheduleJob addobj = new ScheduleJob();
        addobj.setJobName(jobName);
        addobj.setJobGroup(jobGroup);
        addobj.setCronExpression(cronExpression);
        addobj.setSpringName(springName);
        addobj.setBeanClass(beanClass);
        addobj.setDescription(description);
        addobj.setIsActiv(isActiv);
        addobj.setIsConcurrent(isConcurrent);
        Result ret = this.jobTaskService.addTask(addobj);
        outBeanOri.setResult(ret);
        ScheduleJob doAfter = this.jobTaskService.getTaskByGroupAndName(jobGroup, jobName);
        outBeanOri.set("jobId", (Object)doAfter.getId());
        return outBeanOri;
    }
}

