package net.wicp.tams.common.spring.property;

import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

import net.wicp.tams.common.Conf;

@Order(0)
public class TamsPropertySource implements PropertySourceLocator {
	@Override
	public PropertySource<?> locate(Environment environment) {
		CompositePropertySource composite = new CompositePropertySource("tams");
		PropertiesPropertySource mapPropertySource = new PropertiesPropertySource("config", Conf.copyProperties());
		composite.addPropertySource(mapPropertySource);
		return composite;
	}
}
