package net.wicp.tams.common.spring.connector;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.connector.ConfigInstance;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.param.Response;
import net.wicp.tams.common.spring.annotation.metrics.HistogramTams;
import net.wicp.tams.common.spring.annotation.metrics.MeterTams;
import net.wicp.tams.common.web.J2EEAssist;

/***
 * 默认的处理器
 * 
 * @author zhoujunhui
 *
 */
@Slf4j
public class ConnectorServlet extends HttpServlet {
	private static final long serialVersionUID = -1578783960005731596L;

	@Autowired
	private CommonService commonService;
	@Autowired
	public IConfigManager configmanager;
	@MeterTams(isThisClass = true, value = "AllErrorMeter")
	private Meter errorMeter;//调用错误
	@HistogramTams(isThisClass = true, value = "AllHistogram")
	private Histogram histogram;

	@Override
	protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		String requestBody = IOUtil.slurp(req.getInputStream());
		JSONObject params = JSONObject.parseObject(requestBody);
		CusDynaBean inputBean =null;
		resp.setCharacterEncoding("UTF-8");
		try {
			inputBean = configmanager.getInputBeanInputBody(params);	
		} catch (Throwable e) {
			CusDynaBean retBean = ConfigInstance.getInstance().getNullOutBean(ExceptAll.project_undefined);
			retBean.setResult(ExceptAll.project_undefined, e.getMessage());
			resp.setStatus(ExceptAll.project_undefined.getHttpCode());
			J2EEAssist.returnJsonResponse(resp, retBean.getJsonObj().toJSONString());
			errorMeter.mark();
			return;
		}
		long beginTime = System.currentTimeMillis();
		CusDynaBean outbean = commonService.exe(inputBean);		
		histogram.update(System.currentTimeMillis() - beginTime);// 直方图		
		if (outbean == null) {
			resp.setStatus(ExceptAll.project_undefined.getHttpCode());
			outbean = configmanager.getConfig(configmanager.getAppkeyByInputBody(params))
					.newOutBean(ExceptAll.project_undefined);
			outbean.set(Response.errMsg, "返回了空值");
			resp.setStatus(ExceptAll.project_undefined.getHttpCode());
			errorMeter.mark();
		} else {
			Object httpstatusobj = outbean.get(Response.http);
			log.info("-----------------------------http状态:" + httpstatusobj + "-----------------------");
			int status = ExceptAll.getHttp(String.valueOf(httpstatusobj));
			resp.setStatus(status);
			if(status!=200) {
				errorMeter.mark();
			}
		}
		J2EEAssist.returnJsonResponse(resp, outbean.getJsonObj().toJSONString());
	}
}
