package net.wicp.tams.common.spring.binlog;

import java.util.ArrayList;
import java.util.List;

import net.wicp.tams.common.binlog.alone.BinlogStart;
import net.wicp.tams.common.binlog.alone.BusiAssit;

/****
 * spring用于监听的bin
 * 
 * @author Administrator
 *
 */
public abstract class SpringStartBinlogListener {
	private final static List<String> confs = new ArrayList<String>();

	/***
	 * 在annotation解析完成后会调用此方法完成启动
	 * 
	 * @param confId
	 */
	public static final synchronized void startListener(String confId) {
		if (confs.contains(confId)) {
			throw new RuntimeException("已启动此confId的配置，请检查有相同的confId:【" + confId + "】");
		}
		BinlogStart.listeningNonBlocking(BusiAssit.configMap(confId));
		confs.add(confId);
	}
}
