/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring.connector.quartz;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.spring.connector.quartz.Cmd;
import net.wicp.tams.common.spring.quartz.JobTaskService;
import net.wicp.tams.common.spring.quartz.bean.ScheduleJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service(value="quartz.update")
@ConditionalOnProperty(name={"common.spring.quartz.enable"}, havingValue="true")
public class QuartzUpdate
implements IBusiApp {
    private static final Logger log = LoggerFactory.getLogger(QuartzUpdate.class);
    @Autowired
    private JobTaskService jobTaskService;

    public CusDynaBean exe(CusDynaBean inputBean, CusDynaBean outBeanOri) throws ProjectException {
        Cmd cmd = (Cmd)((Object)inputBean.getByType(Cmd.class, "cmd"));
        Integer id = (Integer)inputBean.getByType(Integer.class, "id");
        String cronExpression = inputBean.getStrValueByName("cronExpression");
        ScheduleJob addobj = new ScheduleJob();
        addobj.setId(Long.valueOf(String.valueOf(id)));
        addobj.setCronExpression(cronExpression);
        try {
            switch (cmd) {
                case start: 
                case stop: {
                    this.jobTaskService.changeStatus(addobj.getId(), cmd.name());
                    break;
                }
                case cron: {
                    this.jobTaskService.updateCron(addobj.getId(), addobj.getCronExpression());
                    break;
                }
            }
            outBeanOri.setResult(Result.getSuc());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0job\u9519\u8bef", (Throwable)e);
            outBeanOri.setResult(Result.getError((String)e.getMessage()));
        }
        return outBeanOri;
    }
}

