/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring.connector;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.connector.ConfigInstance;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.spring.annotation.metrics.HistogramTams;
import net.wicp.tams.common.spring.annotation.metrics.MeterTams;
import net.wicp.tams.common.web.J2EEAssist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConnectorServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(ConnectorServlet.class);
    private static final long serialVersionUID = -1578783960005731596L;
    @Autowired
    private CommonService commonService;
    @Autowired
    public IConfigManager configmanager;
    @MeterTams(isThisClass=true, value="AllErrorMeter")
    private Meter errorMeter;
    @HistogramTams(isThisClass=true, value="AllHistogram")
    private Histogram histogram;

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String requestBody = IOUtil.slurp((InputStream)req.getInputStream());
        JSONObject params = JSONObject.parseObject((String)requestBody);
        CusDynaBean inputBean = null;
        resp.setCharacterEncoding("UTF-8");
        try {
            inputBean = this.configmanager.getInputBeanInputBody(params);
        }
        catch (Throwable e) {
            CusDynaBean retBean = ConfigInstance.getInstance().getNullOutBean((IExcept)ExceptAll.project_undefined);
            retBean.setResult((IExcept)ExceptAll.project_undefined, e.getMessage());
            resp.setStatus(ExceptAll.project_undefined.getHttpCode());
            J2EEAssist.returnJsonResponse((HttpServletResponse)resp, (String)retBean.getJsonObj().toJSONString());
            this.errorMeter.mark();
            return;
        }
        long beginTime = System.currentTimeMillis();
        CusDynaBean outbean = this.commonService.exe(inputBean);
        this.histogram.update(System.currentTimeMillis() - beginTime);
        if (outbean == null) {
            resp.setStatus(ExceptAll.project_undefined.getHttpCode());
            outbean = this.configmanager.getConfig(this.configmanager.getAppkeyByInputBody(params)).newOutBean((IExcept)ExceptAll.project_undefined);
            outbean.set("errMsg", (Object)"\u8fd4\u56de\u4e86\u7a7a\u503c");
            resp.setStatus(ExceptAll.project_undefined.getHttpCode());
            this.errorMeter.mark();
        } else {
            Object httpstatusobj = outbean.get("http");
            log.info("-----------------------------http\u72b6\u6001:" + httpstatusobj + "-----------------------");
            int status = ExceptAll.getHttp((String)String.valueOf(httpstatusobj));
            resp.setStatus(status);
            if (status != 200) {
                this.errorMeter.mark();
            }
        }
        J2EEAssist.returnJsonResponse((HttpServletResponse)resp, (String)outbean.getJsonObj().toJSONString());
    }
}

