package net.wicp.tams.common.spring.schema;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

import net.wicp.tams.common.spring.beans.AnnotationBean;

public class AnnotationRegistrar implements ImportBeanDefinitionRegistrar {

	@Override
	public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
		MultiValueMap<String, Object> allAnnotationAttributes = importingClassMetadata
				.getAllAnnotationAttributes("net.wicp.tams.common.spring.annotation.EnableTams");
		String packages = String.valueOf(allAnnotationAttributes.getFirst("packages"));
		RootBeanDefinition rootBeanDefinition = new RootBeanDefinition();
		rootBeanDefinition.setBeanClass(AnnotationBean.class);
		rootBeanDefinition.setLazyInit(false);
		rootBeanDefinition.getPropertyValues().addPropertyValue("annotationPackage", packages);
		String generatedBeanName = AnnotationBean.class.getName();
		registry.registerBeanDefinition(generatedBeanName, rootBeanDefinition);
	}

}
