/***
 * 
 * @author zhoujunhui
 */
package net.wicp.tams.common.spring.beans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.metrics.core.TsMetricAbstractGroup;
import net.wicp.tams.common.spring.annotation.metrics.CounterTams;
import net.wicp.tams.common.spring.annotation.metrics.GaugeTams;
import net.wicp.tams.common.spring.annotation.metrics.HistogramTams;
import net.wicp.tams.common.spring.annotation.metrics.MeterTams;
import net.wicp.tams.common.spring.annotation.metrics.TimerTams;


@Slf4j
public class MetricsBean<T> implements InitializingBean, ApplicationContextAware {

	private ApplicationContext applicationContext;

	private final Annotation annotationInst;
	private final Field field;

	public MetricsBean(Annotation annotationInst, Field field) {
		this.annotationInst = annotationInst;
		this.field = field;
	}

	private T ref;

	public T getRef() {
		return ref;
	}

	public void setRef(T ref) {
		this.ref = ref;
	}

	@SuppressWarnings("rawtypes")
	private Class getClass(Class classz, boolean isThisClass) {
		if (classz.getName().equals("java.lang.Object")) {
			if (isThisClass) {
				return field.getDeclaringClass();
			} else {
				return TsMetricAbstractGroup.class;
			}
		} else {
			return classz;
		}
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		TsMetricAbstractGroup tsgroup = applicationContext.getBean(TsMetricAbstractGroup.class);
		Metric metric = null;
		if (annotationInst instanceof CounterTams) {
			CounterTams counterTams = (CounterTams) annotationInst;
			metric = tsgroup.newCounter(getClass(counterTams.classz(), counterTams.isThisClass()), counterTams.value());
		} else if (annotationInst instanceof MeterTams) {
			MeterTams meterTams = (MeterTams) annotationInst;
			metric = tsgroup.newMeter(getClass(meterTams.classz(), meterTams.isThisClass()), meterTams.value());
		} else if (annotationInst instanceof HistogramTams) {
			HistogramTams histogramTams = (HistogramTams) annotationInst;
			metric = tsgroup.newHistogram(getClass(histogramTams.classz(), histogramTams.isThisClass()),
					histogramTams.value());
		} else if (annotationInst instanceof TimerTams) {
			TimerTams timerTams = (TimerTams) annotationInst;
			metric = tsgroup.newTimer(getClass(timerTams.classz(), timerTams.isThisClass()), timerTams.value());
		} else if (annotationInst instanceof GaugeTams) {
			GaugeTams gaugeTams = (GaugeTams) annotationInst;
			final Counter newCounter = tsgroup.newCounter(getClass(gaugeTams.classz(), gaugeTams.isThisClass()),
					gaugeTams.counterValue());
			metric = tsgroup.newGauge(new Gauge<Integer>() {
				@Override
				public Integer getValue() {
					return (int) newCounter.getCount();
				}
			}, getClass(gaugeTams.classz(), gaugeTams.isThisClass()), gaugeTams.value());
		}

		if (!field.isAccessible()) {
			field.setAccessible(true);
		}
		field.set(ref, metric);
		log.info("the field:{} has inited", field.getName());
	}

	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}
}
