/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring.beans;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.wicp.tams.common.metrics.core.TsMetricAbstractGroup;
import net.wicp.tams.common.spring.annotation.metrics.CounterTams;
import net.wicp.tams.common.spring.annotation.metrics.GaugeTams;
import net.wicp.tams.common.spring.annotation.metrics.HistogramTams;
import net.wicp.tams.common.spring.annotation.metrics.MeterTams;
import net.wicp.tams.common.spring.annotation.metrics.TimerTams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MetricsBean<T>
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MetricsBean.class);
    private ApplicationContext applicationContext;
    private final Annotation annotationInst;
    private final Field field;
    private T ref;

    public MetricsBean(Annotation annotationInst, Field field) {
        this.annotationInst = annotationInst;
        this.field = field;
    }

    public T getRef() {
        return this.ref;
    }

    public void setRef(T ref) {
        this.ref = ref;
    }

    private Class getClass(Class classz, boolean isThisClass) {
        if (classz.getName().equals("java.lang.Object")) {
            if (isThisClass) {
                return this.field.getDeclaringClass();
            }
            return TsMetricAbstractGroup.class;
        }
        return classz;
    }

    public void afterPropertiesSet() throws Exception {
        TsMetricAbstractGroup tsgroup = (TsMetricAbstractGroup)this.applicationContext.getBean(TsMetricAbstractGroup.class);
        Counter metric = null;
        if (this.annotationInst instanceof CounterTams) {
            CounterTams counterTams = (CounterTams)this.annotationInst;
            metric = tsgroup.newCounter(this.getClass(counterTams.classz(), counterTams.isThisClass()), counterTams.value());
        } else if (this.annotationInst instanceof MeterTams) {
            MeterTams meterTams = (MeterTams)this.annotationInst;
            metric = tsgroup.newMeter(this.getClass(meterTams.classz(), meterTams.isThisClass()), meterTams.value());
        } else if (this.annotationInst instanceof HistogramTams) {
            HistogramTams histogramTams = (HistogramTams)this.annotationInst;
            metric = tsgroup.newHistogram(this.getClass(histogramTams.classz(), histogramTams.isThisClass()), histogramTams.value());
        } else if (this.annotationInst instanceof TimerTams) {
            TimerTams timerTams = (TimerTams)this.annotationInst;
            metric = tsgroup.newTimer(this.getClass(timerTams.classz(), timerTams.isThisClass()), timerTams.value());
        } else if (this.annotationInst instanceof GaugeTams) {
            GaugeTams gaugeTams = (GaugeTams)this.annotationInst;
            final Counter newCounter = tsgroup.newCounter(this.getClass(gaugeTams.classz(), gaugeTams.isThisClass()), gaugeTams.counterValue());
            metric = tsgroup.newGauge((Gauge)new Gauge<Integer>(){

                public Integer getValue() {
                    return (int)newCounter.getCount();
                }
            }, this.getClass(gaugeTams.classz(), gaugeTams.isThisClass()), gaugeTams.value());
        }
        if (!this.field.isAccessible()) {
            this.field.setAccessible(true);
        }
        this.field.set(this.ref, metric);
        log.info("the field:{} has inited", (Object)this.field.getName());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

