/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring.beans;

import com.codahale.metrics.Counter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.spring.SpringAssit;
import net.wicp.tams.common.spring.annotation.connector.CacheConnector;
import net.wicp.tams.common.spring.annotation.metrics.CounterTams;
import net.wicp.tams.common.spring.annotation.metrics.GaugeTams;
import net.wicp.tams.common.spring.annotation.metrics.HistogramTams;
import net.wicp.tams.common.spring.annotation.metrics.MeterTams;
import net.wicp.tams.common.spring.annotation.metrics.TimerTams;
import net.wicp.tams.common.spring.beans.MetricsBean;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AnnotationBean
implements BeanFactoryPostProcessor,
BeanPostProcessor,
ApplicationContextAware {
    private String annotationPackage;
    private ApplicationContext applicationContext;

    public String getAnnotationPackage() {
        return this.annotationPackage;
    }

    public void setAnnotationPackage(String annotationPackage) {
        this.annotationPackage = annotationPackage;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        if (this.annotationPackage == null || this.annotationPackage.length() == 0) {
            return;
        }
        if (configurableListableBeanFactory instanceof BeanDefinitionRegistry) {
            try {
                Class scannerClass = ReflectAssist.forName((String)"org.springframework.context.annotation.ClassPathBeanDefinitionScanner");
                Object scanner = scannerClass.getConstructor(BeanDefinitionRegistry.class, Boolean.TYPE).newInstance((BeanDefinitionRegistry)configurableListableBeanFactory, true);
                Class filterClass = ReflectAssist.forName((String)"org.springframework.core.type.filter.AnnotationTypeFilter");
                Object filter = filterClass.getConstructor(Class.class, Class.class, Class.class, Class.class, Class.class).newInstance(Counter.class, GaugeTams.class, HistogramTams.class, MeterTams.class, TimerTams.class);
                Method addIncludeFilter = scannerClass.getMethod("addIncludeFilter", ReflectAssist.forName((String)"org.springframework.core.type.filter.TypeFilter"));
                addIncludeFilter.invoke(scanner, filter);
                String[] packages = StrPattern.split_pattern.compile().split(this.annotationPackage);
                Method scan = scannerClass.getMethod("scan", String[].class);
                scan.invoke(scanner, new Object[]{packages});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Object postProcessBeforeInitialization(Object o, String s) throws BeansException {
        return o;
    }

    public Object postProcessAfterInitialization(Object o, String s) throws BeansException {
        CacheConnector cacheConnector = o.getClass().getDeclaredAnnotation(CacheConnector.class);
        if (cacheConnector != null) {
            String[] beanNamesForType;
            CommonService commonService = (CommonService)this.applicationContext.getBean(CommonService.class);
            for (String beanName : beanNamesForType = this.applicationContext.getBeanNamesForType(o.getClass())) {
                commonService.needCacheMap.put(beanName, cacheConnector.expire());
            }
        }
        this.doWithFields(o, s, CounterTams.class);
        this.doWithFields(o, s, HistogramTams.class);
        this.doWithFields(o, s, TimerTams.class);
        this.doWithFields(o, s, GaugeTams.class);
        this.doWithFields(o, s, MeterTams.class);
        return o;
    }

    private void doWithFields(Object o, String s, Class<? extends Annotation> classA) {
        List<Field> findFields = SpringAssit.selectFields(o.getClass(), classA);
        if (CollectionUtils.isNotEmpty(findFields)) {
            for (Field field : findFields) {
                Annotation declaredAnnotation = field.getDeclaredAnnotation(classA);
                MetricsBean<Object> serviceBean = new MetricsBean<Object>(declaredAnnotation, field);
                serviceBean.setApplicationContext(this.applicationContext);
                serviceBean.setRef(o);
                try {
                    serviceBean.afterPropertiesSet();
                }
                catch (Exception e) {
                    throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u8bbe\u7f6e\u5c5e\u6027\u3010" + s + "\u3011\u5931\u8d25");
                }
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

