/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.wicp.tams.common.spring.constant.SpringConf;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@Service
public class SpringAssit {
    @Autowired
    private Environment environment;

    public Map<String, String> findAllProps() {
        Map<String, LinkedHashMap<String, String>> retlist = this.findAllPropsCollect();
        LinkedHashMap<String, String> allMap = new LinkedHashMap<String, String>();
        for (String ele : retlist.keySet()) {
            SpringConf springConfTemp = null;
            for (SpringConf springConf : SpringConf.values()) {
                if (!ele.startsWith(springConf.getKeyPre())) continue;
                springConfTemp = springConf;
                break;
            }
            if (springConfTemp != null) {
                springConfTemp.getProps().put(ele, retlist.get(ele));
                continue;
            }
            LinkedHashMap<String, String> tempmap = retlist.get(ele);
            allMap.putAll(tempmap);
        }
        for (SpringConf springConf : SpringConf.sortDesc()) {
            for (String ele : springConf.getProps().keySet()) {
                allMap.putAll(springConf.getPropsConvert(ele, allMap));
            }
        }
        return allMap;
    }

    public static List<Field> selectFields(Class<?> targetType, final Class<? extends Annotation> classA) {
        LinkedHashSet<Class> handlerTypes = new LinkedHashSet<Class>();
        Class specificHandlerType = null;
        if (!Proxy.isProxyClass(targetType)) {
            specificHandlerType = ClassUtils.getUserClass(targetType);
            handlerTypes.add(specificHandlerType);
        }
        handlerTypes.addAll(ClassUtils.getAllInterfacesForClassAsSet(targetType));
        final ArrayList<Field> retlist = new ArrayList<Field>();
        for (Class currentHandlerType : handlerTypes) {
            Class targetClass = specificHandlerType != null ? specificHandlerType : currentHandlerType;
            ReflectionUtils.doWithFields((Class)targetClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    Object declaredAnnotation = field.getDeclaredAnnotation(classA);
                    if (declaredAnnotation != null) {
                        retlist.add(field);
                    }
                }
            });
        }
        return retlist;
    }

    public static Set<Method> detectHandlerFiled(Object handler, final Class<? extends Annotation> classA, ApplicationContext applicationContext) {
        Class handlerType = handler instanceof String ? applicationContext.getType((String)handler) : handler.getClass();
        Class userType = ClassUtils.getUserClass((Class)handlerType);
        Set methods = MethodIntrospector.selectMethods((Class)userType, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

            public boolean matches(Method method) {
                Annotation findAnnotation = AnnotationUtils.findAnnotation((Method)method, (Class)classA);
                return findAnnotation != null;
            }
        });
        return methods;
    }

    public Map<String, LinkedHashMap<String, String>> findAllPropsCollect() {
        LinkedHashMap<String, LinkedHashMap<String, String>> result = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (Map.Entry<String, PropertySource<?>> entry : this.getPropertySources().entrySet()) {
            PropertySource<?> source = entry.getValue();
            String sourceName = entry.getKey();
            if (sourceName.startsWith("tams:") || !(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            for (String name : enumerable.getPropertyNames()) {
                properties.put(name, String.valueOf(enumerable.getProperty(name)));
            }
            if (properties == null || !MapUtils.isNotEmpty(properties)) continue;
            result.put(sourceName, properties);
        }
        return result;
    }

    private Map<String, PropertySource<?>> getPropertySources() {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = null;
        sources = this.environment != null && this.environment instanceof ConfigurableEnvironment ? ((ConfigurableEnvironment)this.environment).getPropertySources() : new StandardEnvironment().getPropertySources();
        for (PropertySource source : sources) {
            this.extract("", map, source);
        }
        return map;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }
}

