package net.wicp.tams.common.spring.connector.quartz;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.spring.quartz.JobTaskService;
import net.wicp.tams.common.spring.quartz.bean.ScheduleJob;

@Service(value = "quartz.select")
@ConditionalOnProperty(name = "common.spring.quartz.enable", havingValue = "true")
public class QuartzSelect implements IBusiApp {

	@Autowired
	private JobTaskService jobTaskService;

	@Override
	public CusDynaBean exe(CusDynaBean inputBean, CusDynaBean outBeanOri) throws ProjectException {
		String jobName = inputBean.getStrValueByName("jobName");
		String jobGroup = inputBean.getStrValueByName("jobGroup");
		if ((StringUtil.isNotNull(jobName) && StringUtil.isNull(jobGroup))
				|| (StringUtil.isNull(jobName) && StringUtil.isNotNull(jobGroup))) {
			outBeanOri.setResult(Result.getError("jobName和jobGroup必须同时输入"));
			return outBeanOri;
		}
		List<ScheduleJob> retlist = null;
		if (StringUtil.isNotNull(jobName) && StringUtil.isNotNull(jobGroup)) {
			retlist = new ArrayList<>();
			ScheduleJob temp = jobTaskService.getTaskByGroupAndName(jobGroup, jobName);
			retlist.add(temp);
		} else {
			retlist = jobTaskService.getAllTask();
		}
		outBeanOri.set("joblist", retlist);
		return outBeanOri;
	}
}
