package net.wicp.tams.common.spring.connector;

import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.connector.executor.IBusiManager;

import org.springframework.context.ApplicationContext;

/***
 * 由spring的bean名决定busi实例
 * 
 * @author zhoujunhui
 *
 */
public class SpringBusiManager implements IBusiManager {
	private final ApplicationContext context;

	public SpringBusiManager(ApplicationContext context) {
		this.context = context;
	}

	@Override
	public IBusiApp getBean(String appKey) {
		IBusiApp retobj = (IBusiApp) context.getBean(appKey);
		return retobj;
	}

	@Override
	public void refresh() {
		throw new IllegalAccessError("暂不支持热加载");
	}

}
